/*
 * Based on systemd's lookup3.h
 * https://www.freedesktop.org/wiki/Software/systemd/
 * Modified by Qualys, January 2019
 */

#pragma once

#include <stddef.h>
#include <stdint.h>

void jenkins_hashlittle2(const void *key, size_t length, uint32_t *pc, uint32_t *pb);

static inline uint64_t hash64(const void *data, size_t length) {
        uint32_t a = 0, b = 0;

        jenkins_hashlittle2(data, length, &a, &b);

        return ((uint64_t) a << 32ULL) | (uint64_t) b;
}

