/*
 * Based on systemd's string-util.h
 * https://www.freedesktop.org/wiki/Software/systemd/
 * Modified by Qualys, January 2019
 */

/* SPDX-License-Identifier: GPL-3.0-or-later */
#pragma once

#include <stddef.h>
#include <string.h>

#define WHITESPACE        " \t\n\r"
#define DIGITS            "0123456789"

static inline char *startswith(const char *s, const char *prefix) {
        size_t l;

        l = strlen(prefix);
        if (strncmp(s, prefix, l) == 0)
                return (char*) s + l;

        return NULL;
}

