package services::Controller::Chained::empty_pathparts;

use strict;
use warnings;

use base qw/Catalyst::Controller/;

=head1 NAME

services::Controller::Chained::empty_pathparts; - Catalyst Controller

=head1 DESCRIPTION

This is a controller used for testing the chained actions system.  It is used to
make sure that when you have lots of chained actions with mutiply endpoints and
no pathparts things work as expected.

Here is the example case.  We have a data model of feedrolls, which is a model
to aggregate syndicated feeds.  Each feedroll in the feedrolls model is a list
of feeds from various websites.

=head1 METHODS

The following methods are used by this controller.

=head2 root

This is the root action which does nothing except serve as a startpoint in the chain.

=cut

sub feedrolls :Chained('/') CaptureArgs(0)
{
	my ($self, $c ) = @_;
}


=head2 feedrolls_all

An endpoint to list of all available feedrolls.  This would be accessed via a url like the
following ".../feedrolls".

=cut

sub feedrolls_all :Chained('feedrolls') PathPart('') Args(0)
{
    my ($self, $c ) = @_;
    
    $c->response->body("feedrolls_all");
}


=head2 feedrolls_new

Another endpoint for the feedrolls listing.  In this one we'd just have the last few newest
entries returned.  It's url would look like the following: ".../feedrolls/new".

=cut

sub feedrolls_new :Chained('feedrolls') PathPart('new') Args(0)
{
    my ($self, $c ) = @_;
    
    $c->response->body("feedrolls_new");
}

=head2 feedroll

Get the data associated with the given feedroll_id and make sure it exists.  This is not an
endpoint, but serves as a common root to return info on the feedroll itself.

=cut

sub feedroll :Chained('feedrolls') PathPart('') CaptureArgs(1)
{
    my ($self, $c, $feedroll_id ) = @_;
    
    $c->stash->{feedroll_id} = $feedroll_id;
}


=head2 feedroll_all

An endpoint to list of all available feeds in a given feedroll.  This would be accessed via a url 
like the following: ".../feedrolls/[feedroll_id]".

=cut

sub feedroll_all :Chained('feedroll') PathPart('') Args(0)
{
    my ($self, $c ) = @_;
    
    $c->response->body("feedroll_all:".$c->stash->{feedroll_id});
}


=head2 feedroll_new

Another endpoint for the feedroll listing.  In this one we'd just have the last few newest
entries returned.  It's url would look like the following: ".../feedrolls/[feed_id]/new".

=cut

sub feedroll_new :Chained('feedroll') PathPart('new') Args(0)
{
    my ($self, $c ) = @_;
    
    $c->response->body("feedroll_new:".$c->stash->{feedroll_id});
}


=head1 AUTHOR

John Napiorkowski

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
