#define _BSD_SOURCE
#define _XOPEN_SOURCE 500
#include <stdio.h>
#include <strings.h>
#include <string.h>


char line[4096];

int main(int argc, char **argv)
{
	int base = atoi(argv[2]), llen;
	FILE *infile, *nls, *tmsg;
	char *cur, *start, *end, last = 0, this;

	infile = fopen(argv[1], "r");
	nls = fopen("temp.dt.src", "w");
	tmsg = fopen("temp.dt.tmsg", "w");

	bzero(line, 4096);
	while (fgets(line, 4096, infile)) {
		if (!last) {
			cur = strstr(line, "DESCRIPTION");
			if (!cur) cur = strstr(line, "TYPE_LABEL");
			if (cur) base++;
		} else cur = 0;
		llen = strlen(line);
		line[--llen] = 0;
		if (line[llen - 1] == '\\') this = '\\';
		else this = '\0';

		if (cur) {
			fputs("$\n", tmsg);
			start = strstr(cur, " ");
			if (!start)
				goto EOL;
			start++;
			/* split betwixt nls and tmsg*/
			fprintf(tmsg, "%d %s", base, start--);
			start[0] = 0; start++;
			while (*start && *start == ' ') start++;
			end = start;
			while (*end && *end != ' ') end++;
			end[0] = '\0';
			fprintf(nls, "%s %%|nls-%d-#%s#|\n", line, base, start);
		} else if (last) {
			/* write to tmsg */
			fputs(line, tmsg);
		} else {
			start = line;
			if (*start == '#') {
				start++;
				if (*start=='#' || *start==' ') start++;
				fputs("XCOMM ", nls);
			}
			fputs(start, nls);
			fputs("\n", nls);	
		}
		if (this)
			fprintf(tmsg, "\\\\n");
		if (last || cur) fprintf(tmsg, "\n");
		last = this;
EOL:
		bzero(line, 4096);
	}
	fflush(NULL);
	fclose(tmsg); fclose(nls); fclose(infile);
}
