<cfcomponent displayname="bean" output="false" extends="Bean">

	<cfproperty name="input" displayname="private" required="no"
		type="string"
		hint="The input field from the UI" />
	<cfproperty name="bean" displayname="private" required="no"
		type="string"
		hint="the code generated for the bean" />
	<cfproperty name="beanExtends" displayname="private" required="no"
		type="string"
		hint="the value to be used in the extends attribute of cfcomponent" />
	<cfproperty name="dao" displayname="private" required="no"
		type="string"
		hint="the code generated for the dao" />
	<cfproperty name="daoExtends" displayname="private" required="no"
		type="string"
		hint="the value to be used in the extends attribute of cfcomponent" />
	<cfproperty name="testCase" displayname="private" required="no"
		type="string"
		hint="the code generated for the testCase" />
	<cfproperty name="testCaseExtends" displayname="private" required="no"
		type="string"
		hint="the value to be used in the extends attribute of cfcomponent" />

	<cffunction name="init" access="public" returntype="BeanCreator" output="false">
		<cfargument name="input" type="string" default="" />
		<cfargument name="bean" type="string" default="" />
		<cfargument name="beanExtends" type="string" default="Bean" />
		<cfargument name="dao" type="string" default="" />
		<cfargument name="daoExtends" type="string" default="DAO" />
		<cfargument name="testCase" type="string" default="" />
		<cfargument name="testCaseExtends" type="string" default="TestCase">
		
		<cfset super.init() />
		
		<cfscript>
			super.init();
			
			setInput( arguments.input );
			setBean( arguments.bean );
			setBeanExtends( arguments.beanExtends );
			setDAO( arguments.dao );
			setDAOExtends( arguments.daoExtends );
			setTestCase( arguments.testCase );
			setTestCaseExtends( arguments.testCaseExtends );
		
			return this;
		</cfscript>
	</cffunction>
	
	<cffunction name="getInput" access="public" returntype="string" output="false">
		<cfreturn variables.input />
	</cffunction>
	<cffunction name="setInput" access="public" returntype="void" output="false">
		<cfargument name="input" type="string" output="false" />
		<cfset variables.input = arguments.input />
	</cffunction>
	
	<cffunction name="getBean" access="public" returntype="string" output="false">
		<cfreturn variables.bean />
	</cffunction>
	<cffunction name="setBean" access="public" returntype="void" output="false">
		<cfargument name="bean" type="string" output="false" />
		<cfset variables.bean = arguments.bean />
	</cffunction>
	
	<cffunction name="getBeanExtends" access="public" returntype="string" output="false">
		<cfreturn variables.extends />
	</cffunction>
	<cffunction name="setBeanExtends" access="public" returntype="void" output="false">
		<cfargument name="extends" type="string" required="yes" />
		<cfset variables.extends = arguments.extends />
	</cffunction>
	
	<cffunction name="getDao" access="public" returntype="string" output="false">
		<cfreturn variables.dao />
	</cffunction>
	<cffunction name="setDao" access="public" returntype="void" output="false">
		<cfargument name="dao" type="string" required="yes" />
		<cfset variables.dao = arguments.dao />
	</cffunction>
	
	<cffunction name="getDaoExtends" access="public" returntype="string" output="false">
		<cfreturn variables.daoExtends />
	</cffunction>
	<cffunction name="setDaoExtends" access="public" returntype="void" output="false">
		<cfargument name="daoExtends" type="string" required="yes" />
		<cfset variables.daoExtends = arguments.daoExtends />
	</cffunction>

	<cffunction name="getTestCase" access="public" returntype="string" output="false">
		<cfreturn variables.testCase />
	</cffunction>
	<cffunction name="setTestCase" access="public" returntype="void" output="false">
		<cfargument name="testCase" type="string" required="yes" />
		<cfset variables.testCase = arguments.testCase />
	</cffunction>
	
	<cffunction name="getTestCaseExtends" access="public" returntype="string" output="false">
		<cfreturn variables.testCaseExtends />
	</cffunction>
	<cffunction name="setTestCaseExtends" access="public" returntype="void" output="false">
		<cfargument name="testCaseExtends" type="string" required="yes" />
		<cfset variables.testCaseExtends = arguments.testCaseExtends />
	</cffunction>

</cfcomponent>