<cfcomponent displayname="service" output="false" extends="Service">

	<cffunction name="init" access="public" output="false" returntype="BeanService">
		<cfscript>
			super.init();
			return this;
		</cfscript>
	</cffunction>
	
	
	<!-------------------------------------------------------------->
	
	
	<!---------------------------------------------------------------
		create
	---------------------------------------------------------------->
	<cffunction name="create" access="public" returntype="string" output="false"
		hint="Creates the code. This uses all other methods within this
		object. No validation/error checking takes place in here.
		<br /><br />
		Requires:<br />
		Parsed struct must follow rules set forth in BeanCreatorFacade.
		<br /><br />
		Returns:<br />
		The code.">
		<cfargument name="parsed" type="struct" required="yes" />
		<cfargument name="extends" type="string" required="yes" />
		<cfscript>
			// setup variables
			var title = arguments.parsed.title;
			var varList = arguments.parsed.varList;
			var o = "";
			var i = 1;
			
			// start with the header tag
			if( len(arguments.extends) )
				o = o & newLine( '<cfcomponent displayname="Bean" output="false" extends="#arguments.extends#">', 0 );
			else
				o = o & newLine( '<cfcomponent displayname="Bean" output="false">', 0 );
				
			// put in the property tags
			o = o & generatePropertyTags( varList );
				
			// generate the init method
			o = o & generateInit( arguments.parsed, arguments.extends );
			
			for( ; i lte varList.recordCount; i = i + 1 ) {
				o = addEmptyLine( o );
				o = o & generateGetSet( varList.name[i], varList.type[i] );
			}

			// close the bean
			o = addEmptyLine( o );
			o = o & newLine( '</cfcomponent>', 0 );
			
			// return the bean string
			return o;
		</cfscript>
	</cffunction>
	
	
	<!---------------------------------------------------------------
		generatePropertyTags
	---------------------------------------------------------------->
	<cffunction name="generatePropertyTags" access="private"
		returntype="string" output="false"
		hint="Creates code for all property tags.<br /><br />
		Requires:<br />
		varList must have fields NAME, TYPE, DEFAULT.<br /><br />
		Returns:<br />
		Code for Property Tags.">
		<cfargument name="varList" type="query" required="yes" />
		<cfset var ret = addEmptyLine( '' ) />
		<cfloop query="arguments.varList">
			<cfset ret = ret & createPropertyTag( name, type, default ) />
		</cfloop>
		<cfreturn ret />
	</cffunction>
	
	<!---------------------------------------------------------------
		createPropertyTag
	---------------------------------------------------------------->
	<cffunction name="createPropertyTag" access="private"
		returntype="string" output="false"
		hint="Create code for a single property tag.<br /><br />
		Requires:<br /><br />
		Returns:<br />
		Code for a property tag.">
		<cfargument name="name" type="string" required="yes" />
		<cfargument name="type" type="string" required="yes" />
		<cfargument name="default" type="string" required="yes" />
		<cfscript>
			var df = replace( arguments.default, '##', '', 'all' );
			var t = 1;
			var ret = newLine( '<cfproperty name="#arguments.name#" type="#arguments.type#"' &
									' displayname="private"', t );
			t = t + 1;
			ret = ret & newLine( 'required="false" default="#df#"', t );
			ret = ret & newLine( 'hint="" />', t );
			return ret;
		</cfscript>
	</cffunction>
	
	<!---------------------------------------------------------------
		generateInit
	---------------------------------------------------------------->
	<cffunction name="generateInit" access="private" returntype="string" output="false"
		hint="Creates code for init method.<br /><br />
		Requires:<br />
		Parsed struct must have TITLE, L_TITLE, VARLIST.<br /><br />
		Returns:<br />
		Code for init method.">
		<cfargument name="parsed" type="struct" required="yes" />
		<cfargument name="extends" type="string" default="" />
		<cfscript>
			// setup variables
			var t = 1;
			var o = '';
			var i = 0;
			var vars = arguments.parsed.varList;
			var title = arguments.parsed.title;
			var name = 0;
			
			// create init function header
			o = addEmptyLine( o );
			o = o & newLine( '<cffunction name="init" access="public" returntype="#title#" output="false">', t );
			
			// process the variables list
			t = t + 1;
			for( ; i lte vars.recordCount; i = i + 1 )
				o = o & newLine( '<cfargument name="#vars.name[i]#" type="#vars.type[i]#" default="#vars.default[i]#" />', t );

			// add in the constant text
			o = addEmptyLine( o );
			o = o & newLine( '<cfscript>', t );
			t = t + 1;
			if( len(arguments.extends) ) o = o & newLine( 'super.init();', t );
			o = addEmptyLine( o );
			o = o & newLine( '// set values', t );
			
			for( i = 1; i lte vars.recordCount; i = i + 1 ) {
				name = vars.name[i];
				o = o & newLine( 'set#uCaseFirstLetter( name )#( arguments.#name# );', t );
			}
			
			// finale
			o = addEmptyLine( o );
			o = o & newLine( '// return the object', t );
			o = o & newLine( 'return this;', t );
			t = t - 1;
			o = o & newLine( '&lt;/cfscript&gt;', t );
			t = t - 1;
			o = o & newLine( '&lt;/cffunction&gt;', t );
			
			// return the string
			return o;
		</cfscript>
	</cffunction>
	
	<!---------------------------------------------------------------
		generateGetSet
	---------------------------------------------------------------->
	<cffunction name="generateGetSet" access="private" returntype="string" output="false">
		<cfargument name="name" type="string" required="yes" />
		<cfargument name="type" type="string" required="yes" />
		
		<cfscript>
			// setup variables
			var o = "";
			var t = 1;
			var cname = uCaseFirstLetter( arguments.name );
						
			// create getter
			o = o & newLine( 
				'<cffunction name="get#cname#" access="public" returntype="#arguments.type#" output="false">', t );
			t = t + 1;
			o = o & newLine( '<cfreturn variables.#arguments.name# />', t );
			t = t - 1;
			o = o & newLine( '</cffunction>', t );
			
			// create setter
			o = o & newLine( 
				'<cffunction name="set#cname#" access="public" returntype="void" output="false">', t );
			t = t + 1;
			o = o & newLine( 
				'<cfargument name="#arguments.name#" type="#arguments.type#" required="yes" />', t );
			o = o & newLine( '<cfset variables.#arguments.name# = arguments.#arguments.name# />', t );
			t = t - 1;
			o = o & newLine( '</cffunction>', t );
			
			// return the string
			return o;
		</cfscript>
	</cffunction>
	
</cfcomponent>
