<cfcomponent displayname="service" output="false" extends="Service">

	<cffunction name="init" access="public" output="false" returntype="DaoService">
		<cfscript>
			super.init();
			return this;
		</cfscript>
	</cffunction>
	
	
	<!-------------------------------------------------------------->
	
	
	<!--------------------------------------------------------------------------
		create
	--------------------------------------------------------------------------->
	<cffunction name="create" access="public" returntype="string" output="false"
		hint="Creates the code. This uses all other methods within this
		object. No validation/error checking takes place in here.
		<br /><br />
		Requires:<br />
		Parsed struct must follow rules set forth in BeanCreatorFacade.
		<br /><br />
		Returns:<br />
		The code.">>
		<cfargument name="parsed" type="struct" required="yes" />
		<cfargument name="extends" type="string" required="yes" />
		<cfscript>
			var o = '';
			var t = 0;
			
			if( len(arguments.extends) )
				o = o & newLine( '<cfcomponent displayname="dao" output="false" extends="#arguments.extends#">', t );
			else
				o = o & newLine( '<cfcomponent displayname="dao" output="false">', t );
				
			t = t + 1;
			o = addEmptyLine( o );
			
			o = o & generateDAOCreate( arguments.parsed );
			o = addEmptyLine( o );
			o = o & generateDAORead( arguments.parsed );
			o = addEmptyLine( o );
			o = o & generateDAOUpdate( arguments.parsed );
			o = addEmptyLine( o );
			o = o & generateDAODelete( arguments.parsed );
			
			o = addEmptyLine( o );
			t = t - 1;
			o = o & newLine( '</cfcomponent>', t );
			
			return o;
		</cfscript>
	</cffunction>
	
	<!-----------------------------------------------------------------------------------
		generateDAOCreate
	------------------------------------------------------------------------------------>
	<cffunction name="generateDAOCreate" access="private" returntype="string" output="false">
		<cfargument name="parsed" type="struct" required="yes" />
		<cfscript>
			var o = '';
			var title = arguments.parsed.title;
			var l_title = arguments.parsed.l_title;
			var idName = title & 'ID';
			var t = 1;
			var vars = arguments.parsed.varList;
			var i = 1;
			var comma = 0;
			
			o = addIdentifier( 'create' );
			
			// signature
			o = o &	newLine( '<cffunction name="create" access="package" returntype="#title#" output="false">', t );
			t = t + 1;
			o = o & newLine( '<cfargument name="#l_title#" type="#title#" required="yes" />', t );
			o = addEmptyLine( o );
			
			// variables
			o = o & newLine( '&lt;!--- setup variables ---&gt;', t );
			o = o & newLine( '<cfset var q = 0 />', t );
			o = addEmptyLine( o );
			
			// query
			o = o & newLine( '&lt;!--- query ---&gt;', t );
			o = o & newLine( '<cfquery name="q" datasource="##variables.dsn##" maxrows="1">', t );
			t = t + 1;
			o = o & newLine( 'INSERT INTO tbl (', t );
			
			// insert
			t = t + 1;
			for( ; i lte vars.recordCount; i = i + 1 ) {
				if( i neq vars.recordCount )
					o = o & newLine( vars.name[i] & ',', t );
				else
					o = o & newLine( vars.name[i], t );
			}
			t = t - 1;
			o = o & newLine( ') VALUES (', t );
			t = t + 1;
			for( i = 1; i lte vars.recordCount; i = i + 1 ) {
				comma = i neq vars.recordCount;
				o = o & generateQueryParam( l_title, vars.name[i], vars.type[i], '', t, comma );
			}
			t = t - 1;
			o = o & newLine( ')', t );
			
			// select
			o = addEmptyLine( o );
			o = o & newLine( 'SELECT' & TAB & '@@identity AS ' & idName, t );
			o = o & newLine( 'FROM' & TAB & 'tbl', t );
			
			t = t - 1;
			o = o & newLine( '</cfquery>', t );
			o = addEmptyLine( o );
			
			// arguments
			o = o & newLine( '&lt;!--- store and return ---&gt;', t );
			o = o & newLine( '<cfset arguments.#l_title#.set#title#ID( q.#idName# ) />', t );
			o = addEmptyLine( o );
			o = o & newLine( "<cfset arguments.#l_title#.addMessage( '#title# Created' ) />", t );
			o = addEmptyLine( o );
			o = o & newLine( '<cfreturn arguments.#l_title# />', t );
			t = t - 1;
			o = o & newLine( '</cffunction>', t );
			
			return o;
		</cfscript>
	</cffunction>
	
	<!-----------------------------------------------------------------------------------
		generateQueryParam
	------------------------------------------------------------------------------------>
	<cffunction name="generateQueryParam" access="private" returntype="string" output="false">
		<cfargument name="title" type="string" required="yes" />
		<cfargument name="name" type="string" required="yes" />
		<cfargument name="type" type="string" required="yes" />
		<cfargument name="prefix" type="string" required="yes" />
		<cfargument name="tabAmount" type="numeric" required="yes" />
		<cfargument name="comma" type="boolean" default="false" />
		<cfscript>
			var o = '';
			var cfsqltype = '';
			var nullCheck = '';
			var cName = uCaseFirstLetter( arguments.name );
			
			switch( arguments.type ) {
			case 'string':
				cfsqltype = "cf_sql_varchar";
				nullCheck = "##yesNoFormat( not len(arguments.#arguments.title#.get#cName#()) )##";
				break;
			case 'boolean':
				cfsqltype = "cf_sql_bit";
				nullCheck = "##yesNoFormat( not len(arguments.#arguments.title#.get#cName#()) )##";
				break;
			case 'numeric':
				cfsqltype = "cf_sql_integer";
				nullCheck = "##yesNoFormat( not isNumeric( arguments.#arguments.title#.get#cName#() ) )##";
			}
			
			o = newLine( '#arguments.prefix#<cfqueryparam cfsqltype="#cfsqltype#"' &
					' value="##arguments.#arguments.title#.get#cName#()##"', arguments.tabAmount );
			
			if( comma )
				o = o & newLine( 'null="#nullCheck#" />,', arguments.tabAmount + 2 );
			else
				o = o & newLine( 'null="#nullCheck#" />', arguments.tabAmount + 2 );
				
			return o;
		</cfscript>	
	</cffunction>
	
	<!-----------------------------------------------------------------------------------
		generateDAORead
	------------------------------------------------------------------------------------>
	<cffunction name="generateDAORead" access="private" returntype="string" output="false">
		<cfargument name="parsed" type="struct" required="yes" />
		<cfscript>
			var o = '';
			var title = arguments.parsed.title;
			var l_title = arguments.parsed.l_title;
			var t = 1;
			
			o = addIdentifier( 'read' );
			
			o = o & newLine( '<cffunction name="read" access="package" returntype="#title#" output="false">', t );
			t = t + 1;
			o = o & newLine( '<cfargument name="#l_title#" type="#title#" required="yes" />', t );
			o = addEmptyLine( o );
			
			o = o & newLine( '&lt;!--- setup variables ---&gt;', t );
			o = o & newLine( '<cfset var q = 0 />', t );
			o = o & newLine( '<cfset var qStruct = 0 />', t );
			o = o & newLine( '<cfset var #l_title#ID = arguments.#l_title#.get#title#ID() />', t );
			o = addEmptyLine( o );
			
			o = o & newLine( '&lt;!--- the query ---&gt;', t );
			o = o & newLine( '<cfquery name="q" datasource="##variables.dsn##">', t );
			t = t + 1;
			o = o & newLine( 'SELECT' & TAB & '*', t );
			o = o & newLine( 'FROM' & TAB & 'tbl', t );
			o = o & newLine( 'WHERE' & TAB & '#l_title#ID = **FILLMEIN**', t );
			t = t - 1;
			o = o & newLine( '</cfquery>', t );
			o = addEmptyLine( o );
			
			o = o & newLine( '&lt;!--- post processing ---&gt;', t );
			o = o & newLine( '<cfif q.recordCount eq 0>', t );
			t = t + 1;
			o = o & newLine( '<cfthrow type="ENODATA" message="#title# not found." detail="#l_title#ID=[###l_title#ID##]" />', t );
			t = t - 1;
			o = o & newLine( '</cfif>', t );
			o = addEmptyLine( o );
			
			o = o & newLine( '<cfset qStruct = variables.queryUtil.queryToStruct( q ) />', t );
			o = o & newLine( '<cfset arguments.#l_title#.init( argumentcollection = qStruct ) />', t );
			o = addEmptyLine( o );
			
			o = o & newLine( '&lt;!--- return object ---&gt;', t );
			o = o & newLine( '<cfreturn arguments.#l_title# />', t );
			t = t - 1;
			o = o & newLine( '</cffunction>', t );
			
			return o;
		</cfscript>
	</cffunction>
	
	<!-----------------------------------------------------------------------------------
		generateDAOUpdate
	------------------------------------------------------------------------------------>
	<cffunction name="generateDAOUpdate" access="private" returntype="string" output="false">
		<cfargument name="parsed" type="struct" required="yes" />
		<cfscript>
			var o = "";
			var title = arguments.parsed.title;
			var l_title = arguments.parsed.l_title;
			var t = 1;
			var i = 1;
			var vars = arguments.parsed.varList;
			
			o = addIdentifier( 'update' );
			o = o & newLine( '<cffunction name="update" access="package" returntype="#title#" output="false">', t );
			t = t + 1;
			o = o & newLine( '<cfargument name="#l_title#" type="#title#" required="yes" />', t );
			o = addEmptyLine( o );
			o = o & newLine( '&lt;!--- setup variables ---&gt;', t );
			o = addEmptyLine( o );
			
			o = o & newLine( '&lt;!--- query ---&gt;', t );
			o = o & newLine( '<cfquery datasource="##variables.dsn##">', t );
			t = t + 1;
			
			o = o & newLine( 'UPDATE' & TAB & 'tbl', t );
			t = t + 2;
			
			for( ; i lte vars.recordCount; i = i + 1 )
				if( i eq 1 )
					o = o & generateQueryParam( l_title, vars.name[i], vars.type[i],
						'SET' & TAB & TAB & '#vars.name[i]# = ', t - 2, true );
				else
					if( i eq vars.recordCount )
						o = o & generateQueryParam( l_title, vars.name[i], vars.type[i], '#vars.name[i]# = ', t );
					else
						o = o & generateQueryParam( l_title, vars.name[i], vars.type[i], '#vars.name[i]# = ', t, true );
		
			t = t - 2;
			o = o & newLine( 'WHERE' & TAB & '#l_title#ID = ***FILLMEIN***', t );
			t = t - 1;
			o = o & newLine( '</cfquery>', t );
			o = addEmptyLine( o );
			o = o & newLine( "<cfset arguments.#l_title#.addMessage( '#title# Updated' ) />", t );
			o = addEmptyLine( o );
			
			o = o & newLine( '&lt;!--- return the original object ---&gt;', t );
			o = o & newLine( '<cfreturn arguments.#l_title# />', t );
			t = t - 1;
			o = o & newLine( '</cffunction>', t );
			
			return o;
		</cfscript>	
	</cffunction>
	
	<!-----------------------------------------------------------------------------------
		generateDAODelete
	------------------------------------------------------------------------------------>
	<cffunction name="generateDAODelete" access="private" returntype="string" output="false">
		<cfargument name="parsed" type="struct" required="yes" />
		<cfscript>
			var o = '';
			var title = arguments.parsed.title;
			var l_title = arguments.parsed.l_title;
			var cTitle = uCaseFirstLetter( title );
			var t = 1;;
			
			o = addIdentifier( 'delete' );
			
			o = o & newLine( '<cffunction name="delete" access="package" returntype="#title#" output="false">', t );
			t = t + 1;
			o = o & newLine( '<cfargument name="#l_title#" type="#title#" required="yes" />', t );
			o = addEmptyLine( o );
			
			o = o & newLine( '&lt;!--- setup variables ---&gt;', t );
			o = o & newLine( '<cfset var #l_title#ID = arguments.#l_title#.get#cTitle#ID() />', t );
			o = addEmptyLine( o );
			
			o = o & newLine( '&lt;!--- delete query ---&gt;', t );
			o = o & newLine( '<cfquery datasource="##variables.dsn##">', t );
			t = t + 1;
			o = o & newLine( 'DELETE', t );
			o = o & newLine( 'FROM' & TAB & 'tbl', t );
			o = o & newLine( 'WHERE' & TAB & '#l_title#ID = ###l_title#ID##', t );
			t = t - 1;
			o = o & newLine( '</cfquery>', t );
			o = addEmptyLine( o );
			o = o & newLine( "<cfset arguments.#l_title#.addMessage( '#title# Deleted' ) />", t );
			
			o = addEmptyLine( o );
			o = o & newLine( '<cfreturn arguments.#l_title# />', t );
			t = t - 1;
			o = o & newLine( '</cffunction>', t );
			
			return o;
		</cfscript>	
	</cffunction>
	
	<!--------------------------------------------------------------------------
		addIdentifier
	--------------------------------------------------------------------------->
	<cffunction name="addIdentifier" access="private" returntype="string" output="false">
		<cfargument name="identifier" type="string" required="yes" />
		<cfscript>
			var o = '';
			
			o = o & newLine( '&lt;!--------------------------------------------------------------------------', 1 );
			o = o & newLine( arguments.identifier, 2 );
			o = o & newLine( '---------------------------------------------------------------------------&gt;', 1 );
			
			return o;
		</cfscript>
	</cffunction>
	
</cfcomponent>
