<cfcomponent displayname="abstract" output="false"
	hint="This was taken from the CFCUnit framework.">
	
	<cfproperty name="NULL" displayname="private" required="yes"
		type="string" default="" hint="null value" />
		
	<cfset variables.NULL = '' />
	
	<!--------------------------------------------------------------->
		
	<cffunction name="newObject" returntype="Any" access="private" output="false"
		hint="Loosely based off of cfcunit's newObject(). I couldn't use the
		coldfusion specific types, because I am developing on bluedragon.">
		<cfargument name="type" type="string" required="true"/>
		<cfscript>
			var ret = NULL;
			
			ret = createObject( 'component', arguments.type );
			
			return ret.init();
		</cfscript>
	</cffunction>
	
	<!--------------------------------------------------------------->
	
	<cffunction name="newJavaObject" returntype="any" access="private" output="false"
		hint="Creates an uninitialized java object. From cfcunit.">
		<cfargument name="class" type="string" required="true"/>
		<cfset var ret = NULL>
		
		<cfset ret = CreateObject("java", arguments.class)>
		
		<cfreturn ret/>
	</cffunction>
	
	<!--------------------------------------------------------------->
	
	<cffunction name="abort" access="private" output="false" retuntype="void"
		hint="a cfscript version of &lt;cfabort&gt;">
		<cfargument name="message" type="string" default="" />
		<cfabort showerror="#arguments.message#" />
	</cffunction>

	<!--------------------------------------------------------------->
	
	<cffunction name="dump" access="private" output="false" returntype="string"
		hint="a cfscript version of &lt;cfdump&gt;.">
		<cfargument name="v" type="any" required="yes"
			hint="the variable to process in the &lt;cfdump&gt;." />
		<cfset var content = 0 />
		<cfsavecontent variable="content">
			<cfdump var="#arguments.v#" />
		</cfsavecontent>
		<cfreturn content />
	</cffunction>
	
	<!--------------------------------------------------------------->
	
	<cffunction name="throw" access="private" output="false" returntype="string"
		hint="a cfscript version of &lt;cfthrow&gt;.">
		<cfargument name="type" type="string" default="Application" />
		<cfargument name="message" type="string" default="" />
		<cfargument name="detail" type="string" default="" />
		<cfargument name="errorCode" type="string" default="" />
		<cfargument name="extendedInfo" type="string" default="" />
		<cfargument name="object" type="any" default=""
			hint="ya know. I have never used this one." />
		
		<cfif isObject( arguments.object )>
			<cfthrow object="#aguments.object#" />
		<cfelse>
			<cfthrow
				type="#arguments.type#"
				message="#arguments.message#"
				detail="#arguments.detail#"
				errorCode="#arguments.errorCode#"
				extendedInfo="#arguments.extendedInfo#" />
		</cfif>
	</cffunction>

</cfcomponent>