<cfcomponent displayname="service" output="false" extends="Service">

	<cffunction name="init" access="public" output="false" returntype="TestCaseService">
		<cfscript>
			super.init();
			return this;
		</cfscript>
	</cffunction>
	
	
	<!-------------------------------------------------------------->
	
	
	<!-----------------------------------------------------------------------------------
		create
	------------------------------------------------------------------------------------>
	<cffunction name="create" access="public" returntype="string" output="false"
		hint="Creates the code. This uses all other methods within this
		object. No validation/error checking takes place in here.
		<br /><br />
		Requires:<br />
		Parsed struct must follow rules set forth in BeanCreatorFacade.
		<br /><br />
		Returns:<br />
		The code.">>
		<cfargument name="parsed" type="struct" required="yes" />
		<cfargument name="extends" type="string" default="" />
		<cfscript>
			var o = '';
			var t = 0;
			var i = 1;
			var vlist = parsed.varList;
			var vlistlen = vlist.recordCount;
			var title = arguments.parsed.title;
			var l_title = arguments.parsed.l_title;
			var init = 0;
			
			if( len(arguments.extends) ) {
				o = newLine( '<cfcomponent displayname="test case" output="false"', t );
				t = t + 1;
				o = o & newLine( 'extends="#arguments.extends#">', t );
			} else
				o = newLine( '<cfcomponent displayname="test case" output="false">', t );
			
			o = addEmptyLine( o );
			o = o & newLine( '<cfscript>', t );
			o = o & newLine( '&lt;/cfscript&gt;', t );
			
			o = addEmptyLine( o, 2 );
			o = o & newLine( '<!--- BUILT-IN METHODS --->', t );
			o = o & emptyFunction( name='setup', interior="#TAB##TAB##TAB##l_title# = newObject( '#title#' );#CR#" );
			o = o & emptyFunction( name='teardown', interior="#TAB##TAB##TAB##l_title# = 0;#CR#" );
			
			o = addEmptyLine( o, 2 );
			o = o & newLine( '<!--- TESTS --->', t );
			
			init = newLine( 'var e = 0;', t + 2 );
			init = addEmptyLine( init );
			init = init & newLine( 'try {', t + 2 );
			init = init & newLine( '#l_title#.init();', t + 3 );
			init = init & newLine( '} catch ( Any e ) {', t + 2 );
			init = init & newLine( 'fail( e );', t + 3 );
			init = init & newLine( '}', t + 2 );
			o = o & emptyFunction( name='testInit', interior=init );
			
			for( ; i lte vlistlen; i = i + 1 )
				o = o & basicTestFunction( vlist.name[i], vlist.type[i],
					vlist.default[i], arguments.parsed.l_title );
			
			t = t - 1;
			o = addEmptyLine( o );
			o = o & newLine( '&lt;/cfcomponent&gt;', t );
			
			return o;
		</cfscript>
	</cffunction>
	
	<cffunction name="emptyFunction" access="private" returntype="string" output="false">
		<cfargument name="name" type="string" required="yes" />
		<cfargument name="access" type="string" default="public" />
		<cfargument name="output" type="string" default="false" />
		<cfargument name="returntype" type="string" default="void" />
		<cfargument name="interior" type="string" default="" />
		<cfscript>
			var o = '';
			var t = 1;
			
			o = addEmptyLine( o );
			o = o & newLine( '<cffunction name="#arguments.name#" ' &
				'access="#arguments.access#" output="#arguments.output#" ' &
				'returntype="#arguments.returntype#">', t );
			if( len(arguments.interior) ) {
				o = o & newLine( '<cfscript>', t + 1 );
				o = o & arguments.interior;
				o = o & newLine( '&lt;/cfscript&gt;', t + 1);
			}
			o = o & newLine( '&lt;/cffunction&gt;', t );
				
			return o;
		</cfscript>
	</cffunction>
	
	<cffunction name="basicTestFunction" access="private" returntype="string" output="false">
		<cfargument name="name" type="string" required="yes" />
		<cfargument name="type" type="string" required="yes" />
		<cfargument name="default" type="string" required="yes" />
		<cfargument name="objectName" type="string" required="yes" />
		<cfscript>
			var o = '';
			var t = 1;
			var obj = '';
			var cName = uCaseFirstLetter( arguments.name );
			var setter = '#arguments.objectName#.set#cName#( testValue )';
			var getter = '#arguments.objectName#.get#cName#()';
			
			o = addEmptyLine( o );
			o = o & newLine( '<cffunction name="test#cName#"' &
					' access="public" output="false" returntype="void">', t );
					
			t = t + 1;
			o = o & newLine( '<cfscript>', t );
			
			t = t + 1;
			switch( lcase( arguments.type ) ) {
			case 'string':
				o = o & newLine( "var testValue = 'test string';", t );
				o = o & newLine( '#setter#;', t );
				o = o & newLine( 'assertEqualsString( testValue, #getter#,', t );
				o = o & newLine( '"' & "Not equal. Returned '###getter###'. " &
									"Expected 'test string'." & '" );', t + 1 );
				break;
			case 'numeric':
				o = o & newLine( 'var testValue = -99;', t );
				o = o & newLine( '#setter#;', t );
				o = o & newLine( 'assertEqualsNumber( testValue, #getter#,', t );
				o = o & newLine( '"' & "Not equal. Returned '###getter###'. " &
									"Expected '-99'." & '" );', t + 1 );
				break;
			case 'boolean':
				o = o & newLine( 'var testValue = true;', t );
				o = o & newLine( '#setter#;', t );
				o = o & newLine( 'assertTrue( testValue, #getter#,', t );
				o = o & newLine( '"' & "Not Equal. Return false. Expected true." &
							 '" );', t + 1 );
				break;
			case 'struct':
				o = o & newLine( 'var testValue = structNew();', t );
				o = addEmptyLine( o );
				o = o & newLine( "testValue.first = 'test value';", t );
				o = o & newLine( "testValue.second = 100;", t );
				o = addEmptyLine( o );
				o = o & newLine( '#setter#;', t );
				o = o & newLine( 'assertEqualsStruct( testValue, #getter#, "' &
						"Structs not equal." & '" );', t );
				break;
			case 'array':
				o = o & newLine( 'var testValue = arrayNew(1);', t );
				o = addEmptyLine( o );
				o = o & newLine( "testValue[1] = 'test';", t );
				o = o & newLine( "testValue[2] = 2;", t );
				o = o & newLine( "testValue[3] = 'what a word';", t );
				o = addEmptyLine( o );
				o = o & newLine( '#setter#;', t );
				o = o & newLine( 'assertEqualsArray( testValue, #getter#, "' &
						"Arrays not equal." & '" );', t );
				break;
			case 'query':
				o = o & newLine( "var testValue = queryNew( 'first,second,third' );", t );
				o = addEmptyLine( o );
				o = o & newLine( 'queryAddRow( testValue );', t );
				o = o & newLine( "querySetCell( testValue, 'first', 1 );", t );
				o = o & newLine( "querySetCell( testValue, 'second', 'two' );", t );
				o = o & newLine( "querySetCell( testValue, 'third', 'next' );", t );
				o = addEmptyLine( o );
				o = o & newLine( '#setter#;', t );
				o = o & newLine( 'assertEqualsQuery( testValue, #getter#, "' &
						"Queries not equal." & '" );', t );
				break;
			default:
				o = o & newLine( "var testValue = createObject( 'component',", t );
				t = t + 2;
				obj = replace( arguments.default, '##', '', 'all' );
				o = o & newLine( "'#obj#' );", t );
				t = t - 2;
				o = addEmptyLine( o );
				o = o & newLine( '#setter#;', t );
				o = o & newLine( '// yeah, I really dont know how to check these yet.', t );
				break;
			}
			
			t = t - 1;
			o = o & newLine( '&lt;cfscript&gt;', t );
			
			t = t - 1;
			o = o & newLine( '&lt;/cffunction&gt;', t );
			
			return o;
		</cfscript>
	</cffunction>
	
</cfcomponent>
