#!/bin/bash
#
# Merges the given source files and builds the program in separate compilation
# and linker passes.
# Output is executable "testprog", merged source file "testprog_comb.c", object
# file "testprog_comb.o" and multiple *.o files containing preprocessed code
# from corresponding C file.
#

# uncomment this to prevent actual compilation
#export CILLY_DONT_COMPILE_AFTER_MERGE=1

# compile first, produces preprocessed code in *.o files instead of real object
# files
cilly --merge -c main.c
cilly --merge -c test1.c
cilly --merge -c test2.c

# then link, takes preprocessed code in *.o files instead of real object files
# and produces final merge and executable
cilly --merge --keepmerged -o testprog main.o test1.o test2.o


