package de.bitecode.bshbot;

import org.jibble.pircbot.*;
import bsh.*;
import java.io.*;
import java.util.HashSet;

/** A PIrcBot that gives you the power of BeanShell.
 *
 * @author Robert Schuster
 */

public class BshBot extends PircBot
{

	Interpreter inter;
	BufferedReader readerOut, readerErr;

	boolean running = true;

	String channel;

	HashSet masters = new HashSet();

	public BshBot(String channel, String master) throws Exception
	{
		this.channel = channel;

		addMaster(master);

		setName("BshBot");
		System.out.print("connecting ...");
		connect("irc.gnu.org");
		System.out.println("done!");
		joinChannel(channel);

		PipedInputStream piso = new PipedInputStream();
		PipedOutputStream poso = new PipedOutputStream(piso);
		readerOut = new BufferedReader(new InputStreamReader(piso));

		PipedInputStream pise = new PipedInputStream();
		PipedOutputStream pose = new PipedOutputStream(pise);
		readerErr = new BufferedReader(new InputStreamReader(pise));

		BufferedReader readerIn = new BufferedReader(new InputStreamReader(System.in));

		inter = new Interpreter(readerIn, new PrintStream(poso, true), new PrintStream(pose, true), true);
		
		// this is a backdoor ...
		inter.set("bot", this);
		
		new Thread(inter).start();

		new Thread(new OutRunner()).start();
		new Thread(new ErrRunner()).start();
	}

	public void addMaster(String newMaster){
		masters.add(newMaster);
	}

	public void onMessage(String channel, String sender,
		String login, String hostname, String message)
	{
		try {

		if ( message.startsWith("bsh:") )
		{
			if ( !masters.contains(sender) ) {
				sendMessage(channel, sender + ": Sorry, you're not one of my masters.");
				return;
			}

			try {
				inter.eval(message.substring(5));
			} catch(InterpreterError ie){
				sendMessage(channel, sender + ":" + ie);
			}

		}

		} catch(Exception e){
			System.out.println("something broke : " + e.getMessage());
			sendMessage(channel, sender + ": could not run your command: " + e);
		}
	}

	public static void main(String[] args) throws Exception
	{
		if ( args.length < 2){
			System.out.println("not enough args!" + args.length);
			System.exit(1);
		}

		BshBot bot = new BshBot("#" + args[0], args[1]);
	}

	private class OutRunner implements Runnable {
		public void run(){
			while(running){
			try {
			String res = readerOut.readLine();
			sendMessage(channel, "bshbot: " + res);
			System.out.println("bshbot: " + res);
			}catch(Exception e){}
			}
		}
	}

	private class ErrRunner implements Runnable {
		public void run(){
			while(running){
			try{
			String res = readerErr.readLine();
			sendMessage(channel, "bshbot: " + res);
			System.err.println("bshbot: " + res);
			}catch(Exception e){}
			}
		}
	}

}
