/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included  with this distribution in *
 * the LICENSE file.                                                         *
 *****************************************************************************/
package org.apache.cocoon.acting;
import Enumerations.EnumerationFactory;

/**
 * A number of constants to represent the possible outcomes of a
 * validation.
 *
 * <table>
 * <tr><td>OK</td><td>no error occurred, parameter successfully checked</td></tr>
 * <tr><td>ERROR</td><td>some error occurred, this is a result that is never set
 *                       but serves as a comparison target</td></tr>
 * <tr><td>ISNULL</td><td>the parameter is null but isn't allowed to</td></tr>
 * <tr><td>TOOSMALL</td><td>either value or length in case of a string is less 
 *                          than the specified minimum</td></tr>
 * <tr><td>TOOLARGE</td><td>either value or length in case of a string is greater 
 *                          than the specified maximum</td></tr>
 * <tr><td>NOMATCH</td><td>a string parameter's value is not matched by the specified
 *                         regular expression</td></tr>
 * <tr><td>NOTPRESENT</td><td>this is returned when the result of a validation is 
 *                            requested but no such result is found in the request attribute
 *                   </td></tr>
 * </table>
 *
 * @author Christian Haul &lt;haul@informatik.tu-darmstadt.de&gt;
 * @version CVS $Revision:$ $Date:$ 
 */

public class ValidatorActionResult extends EnumerationFactory {

  public static final ValidatorActionResult
    OK         = new ValidatorActionResult ("OK"),          // 0
    ERROR      = new ValidatorActionResult ("ERROR"),       // 1
    ISNULL     = new ValidatorActionResult ("ISNULL"),      // 2
    TOOSMALL   = new ValidatorActionResult ("TOOSMALL"),    // 3
    TOOLARGE   = new ValidatorActionResult ("TOOLARGE"),    // 4
    NOMATCH    = new ValidatorActionResult ("NOMATCH"),     // 5
    NOTPRESENT = new ValidatorActionResult ("NOTPRESENT");  // 6

  /**
   * Make constructor private to inhibit creation outside.
   */
  private ValidatorActionResult (String image) {
    super (image);
  }
  private ValidatorActionResult () {
    super ();
  }
}
