
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

class FilePart extends Part {
  final private File file_;
  final private String contentType_;
  private ContentTransferEncoding transferEncoding_;

  FilePart(final String boundary, 
           final String name, final File file) {
    this(boundary, name, file, "text/plain");
  }

  FilePart(final String boundary, 
           final String name, final File file, final String contentType) {
    super(boundary, name, file);
    file_ = file;
    contentType_ = contentType;
  }

  void setTransferEncoding(final ContentTransferEncoding transferEncoding) {
    transferEncoding_ = transferEncoding;
  }

  File getFile() {
    return file_;
  }

  String getContentType() {
    return contentType_;
  }

  ContentTransferEncoding getTransferEncoding() {
    return transferEncoding_;
  }

  @Override
  void write(final OutputStream os)
    throws IOException {

    final PrintWriter pw = new PrintWriter(os);
 
    pw.print("--");
    pw.print(getBoundary());
    pw.print(Form.EOL);
    pw.print("Content-Disposition: form-data; name=\"");
    pw.print(getName());
    pw.print("\"; filename=\"");
    pw.print(file_.getName());
    pw.print("\"");
    pw.print(Form.EOL);
    pw.print("Content-Type: ");
    pw.print(contentType_);
    pw.print(Form.EOL);

    if (transferEncoding_ != null) {
      pw.print("Content-Transfer-Encoding: ");
      pw.print(transferEncoding_);
      pw.print(Form.EOL);
    }
    pw.print(Form.EOL);
    pw.flush();

    InputStream is = null;

    try {
      final byte[] buffer = new byte[1024];

      is = new FileInputStream(file_);

      for (int n = is.read(buffer); n != -1; n = is.read()) {
        os.write(buffer, 0, n);
      }
      os.flush();
      pw.print(Form.EOL);
      pw.flush();
    } finally {
      if (is != null) {
        is.close();
      }
    }
  }
}
