
import java.net.URL;


abstract public class Form {
  final static String EOL = "\r\n";

  final private URL action_;
  final private HttpMethod method_;

  public Form(final URL action, final HttpMethod method) {
    if (action == null) {
      throw new IllegalArgumentException("action cannot be null.");
    }
    action_ = action;
    method_ = method;
  }

  abstract public void submit()
    throws Exception;

  public HttpMethod getMethod() {
    return method_;
  }

  public URL getAction() { 
    return action_;
  }
}
