
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

class MultifilePart extends Part {
  final private List<FilePart> filePart_;

  MultifilePart(final String boundary, final String name) {
    super(boundary, name, null);
    filePart_ = new ArrayList<FilePart>();
  }

  void add(final FilePart filePart) {
    filePart_.add(filePart);
  }

  @Override
  void write(final OutputStream os)
    throws IOException {

    final PrintWriter pw = new PrintWriter(os);

    pw.print(BOUNDARY_LEADER);
    pw.print(getBoundary());
    pw.print(Form.EOL);
    pw.print("Content-Disposition: form-data; name=\"");
    pw.print(getName());
    pw.print("\"");
    pw.print(Form.EOL);
    pw.print("Content-Type: multipart/mixed; boundary=");
    pw.print(filePart_.get(0).getBoundary());
    pw.print(Form.EOL);
    pw.print(Form.EOL);

    for (final FilePart part : filePart_) {
      pw.print(BOUNDARY_LEADER);
      pw.print(part.getBoundary());
      pw.print(Form.EOL);
      pw.print("Content-Disposition: attachment; filename=\"");
      pw.print(part.getFile().getName());
      pw.print("\"");
      pw.print(Form.EOL);
      pw.print("Content-Type: ");
      pw.print(part.getContentType());
      pw.print(Form.EOL);

      if (part.getTransferEncoding() != null) {
        pw.print("Content-Transfer-Encoding: ");
        pw.print(part.getTransferEncoding());
        pw.print(Form.EOL);
      }
      pw.print(Form.EOL);
      pw.flush();

      InputStream is = null;

      try {
        final byte[] buffer = new byte[4096];

        is = new FileInputStream(part.getFile());

        for (int n = is.read(buffer); n != -1; n = is.read(buffer)) {
          os.write(buffer, 0, n);
        }
        os.flush();
        pw.print(Form.EOL);
        pw.flush();
      } finally {
        if (is != null) {
          is.close();
        }
      }
    }
    pw.print(BOUNDARY_LEADER);
    pw.print(filePart_.get(0).getBoundary());
    pw.print("--");
    pw.print(Form.EOL);
    pw.flush();
  }
}
