
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class MultipartForm extends Form {
  final private List<Part> part_;

  public MultipartForm(final URL action) {
    super(action, HttpMethod.post);
    part_ = new ArrayList<Part>();
  }

  public void add(final Part part) {
    part_.add(part);
  }

  public void write(final OutputStream os) 
    throws Exception {

    final PrintWriter pw = new PrintWriter(os);
    final String boundary = part_.get(0).getBoundary();

    pw.print("Content-Type: multipart/form-data; boundary=");
    pw.print(boundary);
    pw.print(Form.EOL);
    pw.print(Form.EOL);
    pw.flush();

    for (final Part part : part_) {
      part.write(os);
    }
    pw.print(Part.BOUNDARY_LEADER);
    pw.print(part_.get(0).getBoundary());
    pw.print("--");
    pw.print(Form.EOL);
    pw.flush();
    os.flush();
  }

  //--------------------------------------------------[ Form implementation ]---
  @Override
  public void submit() 
    throws Exception {

    final HttpURLConnection con = 
      (HttpURLConnection) getAction().openConnection();

    con.setDoInput(true);
    con.setDoOutput(true);
    con.setUseCaches(false);
    con.setRequestMethod("POST");
    con.setRequestProperty("Connection", "Keep-Alive");

    final OutputStream os = con.getOutputStream();

    write(os);
    os.close();

    final int httpStatus = con.getResponseCode();

    if (400 <= httpStatus) {
      throw new IOException("Uploading failed. Server response: " + 
                            httpStatus + " " + con.getResponseMessage());
    }
  }
}
