
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;

class Part {
  final static private Logger log = Logger.getLogger(Part.class.getName());
  final static String BOUNDARY_LEADER = "--";
  final static private SecureRandom RAND = new SecureRandom();

  final static public String createBoundary() {
    long r = 0;

    while (r == 0) {
      r = Math.abs(RAND.nextLong());
    }
    while (Math.log10(r) < 11.0) {
      r = r << 1;
    }
    return Long.toHexString(r).substring(0, 12);
  }

  final private String boundary_;
  final private String name_;
  final private Object value_;

  Part(final String boundary, final String name, final Object value) {
    log.log(Level.INFO, "Part(" + boundary + ", " + name + ", " + value + ")");
    boundary_ = boundary;
    name_ = name;
    value_ = value;
  }

  String getBoundary() {
    return boundary_;
  }

  String getName() {
    return name_;
  }

  void write(final OutputStream os)
    throws Exception {
    /*
     * <boundary>
     * Content-Disposition: form-data; name="<name>"
     *
     * <value>
     */
    final PrintWriter pw = new PrintWriter(os);

    pw.print(BOUNDARY_LEADER);
    pw.print(getBoundary()); 
    pw.print(Form.EOL);
    pw.print("Content-Disposition: form-data; name=\"");
    pw.print(getName());
    pw.print("\"");
    pw.print(Form.EOL);
    pw.print(Form.EOL);
    pw.print(value_);
    pw.print(Form.EOL);
    pw.flush();
  }
}
