
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import junit.framework.TestCase;

public class MultipartFormTest extends TestCase {
  public void test()
    throws Exception {

    final URL url = new URL("http://localhost/dummy");
    final MultipartForm form = new MultipartForm(url);
    final String boundary1 = "2e81d27c68c8";
    final String boundary2 = "43aa12145ba7"; 

    form.add(new Part(boundary1, "amount", new BigDecimal("1.95")));
    form.add(new Part(boundary1, "date", "03031836"));
    form.add(new Part(boundary1, "email_address", "greg@evetts.org"));

    final MultifilePart part = new MultifilePart(boundary1, "file");

    part.add(getFilePart1_(boundary2));
    part.add(getFilePart2_(boundary2));
    form.add(part);

    final ByteArrayOutputStream os = new ByteArrayOutputStream();

    form.write(os);
    os.close();
    
    final String actual = os.toString();
    final Matcher matcher = getExpected_().matcher(actual);

    assertTrue(matcher.matches());
  }

  private FilePart getFilePart1_(final String boundary)
    throws IOException {

    final File file = File.createTempFile("partTest", ".txt");
    final OutputStream fos = new FileOutputStream(file);

    file.deleteOnExit();
    fos.write("Hello World".getBytes());
    fos.close();

    final FilePart part = new FilePart(boundary, "file", file, "text/plain");

    part.setTransferEncoding(ContentTransferEncoding.sevenbit);

    return part;
  }

  private FilePart getFilePart2_(final String boundary)
    throws IOException {

    final File file = File.createTempFile("partTest", ".jpg");
    final OutputStream fos = new FileOutputStream(file);

    file.deleteOnExit();
    fos.write("This represents a binary file".getBytes());
    fos.close();

    final FilePart part = new FilePart(boundary, "file", file, "image/jpg");

    part.setTransferEncoding(ContentTransferEncoding.binary);

    return part;
  }

  private Pattern getExpected_() {
    return Pattern.compile( 
    "Content-Type: multipart/form-data; boundary=2e81d27c68c8\r\n" +
    "\r\n" +
    "--2e81d27c68c8\r\n" +
    "Content-Disposition: form-data; name=\"amount\"\r\n" +
    "\r\n" +
    "1.95\r\n" +
    "--2e81d27c68c8\r\n" +
    "Content-Disposition: form-data; name=\"date\"\r\n" +
    "\r\n" +
    "03031836\r\n" +
    "--2e81d27c68c8\r\n" +
    "Content-Disposition: form-data; name=\"email_address\"\r\n" +
    "\r\n" +
    "greg@evetts.org\r\n" +
    "--2e81d27c68c8\r\n" +
    "Content-Disposition: form-data; name=\"file\"\r\n" +
    "Content-Type: multipart/mixed; boundary=43aa12145ba7\r\n" +
    "\r\n" +
    "--43aa12145ba7\r\n" +
    "Content-Disposition: attachment; filename=\"partTest(\\d+).txt\"\r\n" +
    "Content-Type: text/plain\r\n" +
    "Content-Transfer-Encoding: 7bit\r\n" +
    "\r\n" +
    "Hello World\r\n" +
    "--43aa12145ba7\r\n" +
    "Content-Disposition: attachment; filename=\"partTest(\\d+).jpg\"\r\n" +
    "Content-Type: image/jpg\r\n" +
    "Content-Transfer-Encoding: binary\r\n" +
    "\r\n" +
    "This represents a binary file\r\n" +
    "--43aa12145ba7--\r\n" +
    "--2e81d27c68c8--\r\n");
  }
}
