#! /usr/bin/perl -w

use FileHandle qw/autoflush/;
STDOUT->autoflush(1);

if ($ARGV[0] eq "good") {
    $prog = "cat-cygwin";
} elsif ($ARGV[0] eq "bad") {
    $prog = "cat-native";
} else {
    print "usage: bug.pl [good | bad]\n";
    exit 1;
}

my $src = "./src";
my $dst = "./dst";

print "init\n";

if (! open(DST, "| $prog $dst")) {
    die "DST open failed: $!\n";
}
print "DST open\n";

if (! open(SRC, $src)) {
    die "SRC open failed: $!\n";
}
print "SRC open\n";

while (<SRC>) {
    print "SRC read\n";
    print DST $_;
    print "DST write\n";
}
print "After loop\n";

print "closing SRC\n";
if (! close(SRC)) {
    print "SRC close failed: $!\n";
}

print "closing DST\n";
if (! close(DST)) {
    print "DST close failed: $!\n";
}

print "fini\n";
