/* isfuncs.c provides some is_xxx() to check for valid entries */
/* hoenicka_markus@compuserve.com 2-8-00 */
/* $Id: isfuncs.c,v 1.1 2000/02/09 06:02:30 markus Exp $ */

#include "isfuncs.h"
#include <stdio.h>
#include <string.h>

/**********************************************************************/
/* is_ip: checks whether string contains a valid IP address           */
/*        This function does not verify that the given IP address     */
/*        exists or is accessible, but rather checks whether the      */
/*        string is sane.                                             */
/* Argument: *address: ptr to the string to check                     */
/* Return: 0 if invalid, 1 if valid                                   */
/**********************************************************************/
int is_ip(char *address) {
  char *token[4];
  char ip_address[16];
  int i, n_value;

  /* refuse if string is too long */
  if (strlen(address) > 15) {
    return 0;
  }

  /* make a local copy as strtok modifies its argument */
  strncpy(ip_address, address, 16);
  ip_address[15] = '\0';

  /* now look for four tokens separated by "." */
  token[0] = strtok(ip_address, ".");
  if (token[0] == NULL) {
    return 0;
  }

  token[1] = strtok(NULL, ".");
  if (token[1] == NULL) {
    return 0;
  }

  token[2] = strtok(NULL, ".");
  if (token[2] == NULL) {
    return 0;
  }

  token[3] = strtok(NULL, "\r\n");
  if (token[3] == NULL) {
    return 0;
  }

  /* see whether the tokens are in the allowed numerical range */
  for (i = 0; i < 4; i++) {
    n_value = atoi(token[i]);
    if (n_value < 0 || n_value > 255) {
      return 0;
    }
  }
  return 1;
}

/**********************************************************************/
/* is_port: checks whether string contains a valid port               */
/*          This fn simply ensures that the port is outside the       */
/*          range that the system uses, i.e. > 1024                   */
/* Argument: *address: ptr to the string to check                     */
/* Return: 0 if invalid, 1 if valid                                   */
/**********************************************************************/
int is_port(char *port) {
  if (atoi(port) < 1024) {
    return 0;
  }
  else {
    return 1;
  }
}
