/*+++++++++++++++++
  linklist.c - implements some functions for linked lists
  hoenicka_markus@compuserve.com 7-11-00
  $Id: linklist.c,v 1.1 2000/07/12 04:04:28 markus Exp $
  +++++++++++++++++*/
#include <stdio.h> /* for a definition of NULL */
#include "linklist.h"

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  insert_olili(): inserts a new item into an ordered linked list. The
                  list will be in descending order, so the first item
                  after the sentinel is the item with the highest
                  value

  int insert_olili returns 0 if ok, 1 if error

  struct olili *ptr_first pointer to sentinel

  int value the value to be inserted into the list (value >= 0)

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
int insert_olili(struct olili *ptr_first, int value) {
  struct olili *ptr_before; /* item before insertion point */
  struct olili *ptr_after; /* item after insertion point */
  struct olili *ptr_new_olili; /* new item */

  ptr_before = ptr_first; /* start search at the beginning */
  ptr_after = ptr_before->ptr_next;

  while (ptr_after != NULL) {
    if (ptr_after->fd <= value) { /* sort in descending order */
      break;
    }
    ptr_after = ptr_after->ptr_next;
    ptr_before = ptr_before->ptr_next;
  }

  ptr_new_olili = (struct olili*)malloc(sizeof(struct olili));
  if (ptr_new_olili == NULL) {
    return 1;
  }
  ptr_new_olili->fd = value;
  ptr_before->ptr_next = ptr_new_olili;
  ptr_new_olili->ptr_next = ptr_after;

  return 0;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  delete_olili(): deletes an item from an ordered linked list.

  int delete_olili returns 0 if ok, 1 if error

  struct olili *ptr_first pointer to sentinel

  int value the value to be inserted into the list

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
int delete_olili(struct olili *ptr_first, int value) {
  struct olili *ptr_before; /* item before deletion point */
  struct olili *ptr_curr; /* item at deletion point */
  struct olili *ptr_new_olili; /* new item */

  ptr_before = ptr_first; /* start search at the beginning */
  ptr_curr = ptr_before->ptr_next;

  while (ptr_curr != NULL) {
    if (ptr_curr->fd = value) { /* got it */
      break;
    }
    ptr_curr = ptr_curr->ptr_next;
    ptr_before = ptr_before->ptr_next;
  }

  if (ptr_curr == NULL) {
    return 1;
  }

  ptr_before->ptr_next = ptr_curr->ptr_next;
  free(ptr_curr);
  return 0;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  max_olili(): returns the item with the highest value from an ordered
               linked list.

  int max_olili returns the maximum value, or -1 if an error occurred

  struct olili *ptr_first pointer to sentinel

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* returns highest fd or -1 if error */
int max_olili(struct olili *ptr_first) {
  if (ptr_first != NULL && ptr_first->ptr_next != NULL) {
    return ptr_first->ptr_next->fd;
  }
  else if (ptr_first != NULL) {
    return ptr_first->fd;
  }
  else {
    return -1;
  }
}
