/*********************************************************************
 page.c: functions to display the output of database requests 
 hoenicka_markus@compuserve.com 2-13-00 
 $Id: page.c,v 1.2 2000/06/01 04:58:27 markus Exp markus $
*********************************************************************/

#include <stdio.h>

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  openpager(): returns a pointer to a process which accepts our output
               on stdin. If the suggested process is not available,
               the function will return a pointer to stdout instead.

  FILE *openpager returns a valid writable file pointer

  char *pager ptr to a string with the command line which starts the
              custom pager
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
FILE *openpager(char *pager) {
  FILE *fp;
  
  /* first utter whatever is left in the stdout buffer */
  fflush(stdout);

  if (strcmp("stdout", pager) == 0) {
    return (stdout); /* stdout is explicitly requested */
  }

  /* run the pager program and provide a writable pipe to the new process */
  fp = popen(pager, "w");
  if (fp == NULL) {
    return (stdout); /* if nothing else works, stdout should */
  }

  return (fp);
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  closepager(): closes the pipe to the process with the given FILE ptr

  void closepager no return value

  FILE *fp file pointer to a process pipe which was obtained with a
           call to openpager()
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void closepager(FILE *fp) {
  /* don't attempt to close the file associated with fp if it is
     stdout or, even worse, NULL */
  if (fp != NULL && fp != stdout) {
    pclose(fp);
  }
}
  
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  open_outfile(): returns a pointer to a file which accepts our output
               If the suggested file is not available,
               the function will return a pointer to stdout instead.

  FILE *open_outfile returns a valid writable file pointer

  char *outfile ptr to a string with the filename

  int append if set to 1, the file will be opened for append. If set
              to 0, the file will be opened for (over)write

  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
FILE *open_outfile(char *outfile, int append) {
  FILE *fp;
  
  /* first utter whatever is left in the stdout buffer */
  fflush(stdout);

  /* open the output file */
  if (append) {
    fp = fopen(outfile, "ab");
  }
  else {
    fp = fopen(outfile, "wb");
  }

  if (fp == NULL) {
    return (stdout); /* if nothing else works, stdout should */
  }

  return (fp);
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  close_outfile(): closes an output file

  void close_outfile no return value

  FILE *fp file pointer to an output file obtained through a previous
           call to open_outfile()
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void close_outfile(FILE *fp) {
  /* don't attempt to close the file associated with fp if it is
     stdout or, even worse, NULL */
  if (fp != NULL && fp != stdout) {
    fclose(fp);
  }
}
  
