/* readln.c: some functions to use the readline library and to parse the retrieved string */
/* hoenicka_markus@compuserve.com 2-10-00 */
/* $Id: readln.c,v 1.1 2000/02/11 08:11:28 markus Exp markus $ */

/* Todo: command_generator depends on the extern commands[] thing. Other functions may be rewritten to utilize a ptr to a commandlist to parse different command lists */
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include "readln.h"
#include "strfncs.h"

extern char *xmalloc();
extern COMMAND commands[];

/* Execute a command line. */
int execute_line (char *line, COMMAND *commandlist)
{
  register int i;
  COMMAND *command;
  char *word;

  /* Isolate the command word. */
  i = 0;
  while (line[i] && whitespace (line[i]))
    i++;
  word = line + i;

  while (line[i] && !whitespace (line[i]))
    i++;

  if (line[i])
    line[i++] = '\0';

  command = find_command (word, commandlist);

  if (!command)
    {
      fprintf (stderr, "%s: No such command for refdb.\n", word);
      return (-1);
    }

  /* Get argument to command, if any. */
  while (whitespace (line[i]))
    i++;

  word = line + i;

  /* Call the function. */
  return ((*(command->func)) (word));
}

/* Look up NAME as the name of a command, and return a pointer to that
   command.  Return a NULL pointer if NAME isn't a command name. */
COMMAND *find_command (char *name, COMMAND *commandlist)
{
  register int i;

  for (i = 0; commandlist[i].name; i++)
    if (strcmp (name, commandlist[i].name) == 0)
      return (&commandlist[i]);

  return ((COMMAND *)NULL);
}

/* **************************************************************** */
/*                                                                  */
/*                  Interface to Readline Completion                */
/*                                                                  */
/* **************************************************************** */

/* Tell the GNU Readline library how to complete.  We want to try to complete
   on command names if this is the first word in the line, or on filenames
   if not. */
void initialize_readline ()
{
  /* Allow conditional parsing of the ~/.inputrc file. */
  rl_readline_name = "refdb-admin";

  /* Tell the completer that we want a crack first. */
  rl_attempted_completion_function = (CPPFunction *)refdb_completion;
}

/* Attempt to complete on the contents of TEXT.  START and END bound the
   region of rl_line_buffer that contains the word to complete.  TEXT is
   the word to complete.  We can use the entire contents of rl_line_buffer
   in case we want to do some simple parsing.  Return the array of matches,
   or NULL if there aren't any. */
char **refdb_completion (char *text, int start, int end)
{
  char **matches;

  matches = (char **)NULL;

  /* If this word is at the start of the line, then it is a command
     to complete.  Otherwise it is the name of a file in the current
     directory. */
  if (start == 0)
    matches = completion_matches (text, command_generator);

  return (matches);
}

/* Generator function for command completion.  STATE lets us know whether
   to start from scratch; without any state (i.e. STATE == 0), then we
   start at the top of the list. */
char *command_generator (char *text, int state)
{
  static int list_index, len;
  char *name;

  /* If this is a new word to complete, initialize now.  This includes
     saving the length of TEXT for efficiency, and initializing the index
     variable to 0. */
  if (!state)
    {
      list_index = 0;
      len = strlen (text);
    }

  /* Return the next name which partially matches from the command list. */
  while (name = commands[list_index].name)
    {
      list_index++;

      if (strncmp (name, text, len) == 0)
        return (dupstr(name));
    }

  /* If no names matched, then return NULL. */
  return ((char *)NULL);
}

/* **************************************************************** */
/*                                                                  */
/*                   helper functions                               */
/*                                                                  */
/* **************************************************************** */

char* dupstr (char* s)
{
  char *r;

  r = xmalloc (strlen (s) + 1);
  strcpy (r, s);
  return (r);
}

