/* readln.h: header file for readln.c */
/* hoenicka_markus@compuserve.com 2-10-00 */
/* $Id: readln.h,v 1.1 2000/02/11 08:11:35 markus Exp markus $ */

/* A structure which contains information on the commands this program can understand. */

#include <readline/readline.h>
#include <readline/history.h>

typedef struct {
  char *name;			/* User printable name of the function. */
  Function *func;		/* Function to call to do the job. */
  char *doc;			/* Documentation for this function.  */
} COMMAND;

COMMAND *thecommandlist;

COMMAND *find_command(char *name, COMMAND *commands);
int execute_line (char *line, COMMAND *commands);
char* dupstr (char* s);
char *command_generator (char *text, int state);
char **refdb_completion ();
void initialize_readline ();

