/* refdbsa.c: refdb application server, administrative functions */
/* hoenicka_markus@compuserve.com 6-5-00 */
/* $Id: refdbsa.c,v 1.12 2000/10/31 05:12:47 markus Exp $ */


#include <stdio.h>
#include <string.h>
#include <limits.h>
#include <mysql/mysql.h>
#include <sys/types.h>
#include <unistd.h>
#include <syslog.h>
#include <fcntl.h>

#include "refdb.h"
#include "refdbs.h"
#include "tokenize.h"
#include "strfncs.h"
#include "connect.h"

/* these externs are all defined in refdbs.c */
extern char outomem[];
extern char connerr[];
extern char argerr[];
extern char newln[];
extern char positive[];
extern char negative[];
extern char unknown_command[];
extern char server_ip[];
extern char log_file[];
extern char log_dest[];
extern char log_level[];
extern char port_address[];
extern char refdb_timeout[];
extern char the_fifo[];
extern int n_log_level;
extern int n_log_dest;
extern int n_refdb_timeout;
extern int n_reopen_log;
extern int run;
extern int parent_pid;
extern int fd_fifo;

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  child_confserv(): configures the application server (child process)
                    this fn sends the changes to the parent process
                    via a FIFO/named pipe (via a temp file in CygWin).

  void child_confserv

  int fd file descriptor of socket

  int fd file descriptor of socket

  int optind current index for *inargv array

  int inargc number of arguments in *inargv array

  char** inargv array of arguments

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void child_confserv(int fd, int optind, int inargc, char **inargv) {
  char outbuffer[OUTBUF_LEN];
  int fd_fifo;

  /* we have to treat ping separately as this should not create a temp
     file or use the FIFO */
  if (inargc == optind+1 && strcmp(inargv[optind], "ping") == 0) {
    sprintf(outbuffer, "parent PID: %d  child PID: %d\n", parent_pid, getpid());
    /* use either block 1 or block 2 */
    /* start block 1: this will fail */
    /*  iwrite(fd, outbuffer, strlen(outbuffer)); */ /* buffer w/o terminating \0 */
    /*  iwrite(fd, "", 1); */ /* terminating \0 */
    /* end block 1 */

    /* start block 2: this will work */
    iwrite(fd, outbuffer, strlen(outbuffer)+1); /* buffer w/ terminating \0 */
    /* end block 2 */
    return;
  }

#ifdef CYGWIN
  if (access(the_fifo, F_OK) != -1) { /* old file still exists */
    iwrite(fd, "confserv: appserver busy, try again later\n", 42);
    return;
  }
  else { /* create a temp file with exclusive rights */
    if ((fd_fifo = open(the_fifo, O_WRONLY|O_CREAT|O_EXCL, S_IRUSR|S_IWUSR)) == -1) {
      LOG_PRINT(LOG_WARNING, "cannot open FIFO for writing");
      iwrite(fd, "confserv: remote configure not possible\n", 40);
      return;
    }
  }
#else
  if (fd_fifo != -1) {
    close(fd_fifo); /* this is still open for reading */
    if ((fd_fifo = open(the_fifo, O_WRONLY)) == -1) {
      LOG_PRINT(LOG_WARNING, "cannot open FIFO for writing");
      iwrite(fd, "confserv: remote configure not possible\n", 40);
      return;
    }
  }
  else {
    iwrite(fd, "confserv: remote configure not possible\n", 40);
    return;
  }
#endif /* CYGWIN */
  
  /* the inargv array should have one or two entries: a command and
     an optional argument */
  if (inargc == optind) { /* no argument given */
    iwrite(fd, "confserv: wrong or incomplete command\n", 38);
  }

  if (inargc == optind+1) { /* one argument */
    if (strcmp(inargv[optind], "stop") == 0) {
      if (write(fd_fifo, "1stop", 6) == -1) {
	iwrite(fd, "write error in FIFO\n", 20);
	LOG_PRINT(LOG_WARNING, "write error in FIFO");
      }
      else {
	iwrite(fd, "application server stop submitted\n", 34);
	LOG_PRINT(LOG_INFO, "application server stop submitted");
      }
    }
    else {
      iwrite(fd, "confserv: wrong or incomplete command\n", 38);
    }
  }
  else { /* more than one argument, use first two */
    if (strcmp(inargv[optind], "serverip") == 0) {
      strcpy(server_ip, inargv[optind+1]);
      sprintf(outbuffer, "set serverip to %s submitted\n", server_ip);
      iwrite(fd, outbuffer, strlen(outbuffer));

      sprintf(outbuffer, "2serverip %s", server_ip);
      if (write(fd_fifo, outbuffer, strlen(outbuffer) + 1) == -1) {
	iwrite(fd, "write error in FIFO\n", 20);
	LOG_PRINT(LOG_WARNING, "write error in FIFO");
      }
      else {
	LOG_PRINT(LOG_INFO, "set serverip submitted");
      }
    }
    else if (strcmp(inargv[optind], "timeout") == 0) {
      strcpy(refdb_timeout, inargv[optind+1]);
      n_refdb_timeout = atoi(refdb_timeout);
      sprintf(outbuffer, "set timeout to %d seconds submitted\n", n_refdb_timeout);
      iwrite(fd, outbuffer, strlen(outbuffer));

      sprintf(outbuffer, "2timeout %s", refdb_timeout);
      if (write(fd_fifo, outbuffer, strlen(outbuffer) + 1) == -1) {
	iwrite(fd, "write error in FIFO\n", 20);
	LOG_PRINT(LOG_WARNING, "write error in FIFO");
      }
      else {
	LOG_PRINT(LOG_INFO, "set timeout submitted");
      }
    }
    else if (strcmp(inargv[optind], "logfile") == 0) {
      strcpy(log_file, inargv[optind+1]);
      sprintf(outbuffer, "set logfile to %s submitted\n", log_file);
      iwrite(fd, outbuffer, strlen(outbuffer));

      sprintf(outbuffer, "2logfile %s", log_file);
      if (write(fd_fifo, outbuffer, strlen(outbuffer) + 1) == -1) {
	iwrite(fd, "write error in FIFO\n", 20);
	LOG_PRINT(LOG_WARNING, "write error in FIFO");
      }
      else {
	LOG_PRINT(LOG_INFO, "set logfile submitted");
      }
    }
    else if (strcmp(inargv[optind], "logdest") == 0) {
      strcpy(log_dest, inargv[optind+1]);
      n_log_dest = atoi(log_dest);
      sprintf(outbuffer, "set logdest to %d\n", n_log_dest);
      iwrite(fd, outbuffer, strlen(outbuffer));

      sprintf(outbuffer, "2logdest %s", log_dest);
      if (write(fd_fifo, outbuffer, strlen(outbuffer) + 1) == -1) {
	iwrite(fd, "write error in FIFO\n", 20);
	LOG_PRINT(LOG_WARNING, "write error in FIFO");
      }
      else {
	LOG_PRINT(LOG_INFO, "set logdest submitted");
      }
    }
    else if (strcmp(inargv[optind], "loglevel") == 0) {
      strcpy(log_level, inargv[optind+1]);
      n_log_level = atoi(log_level);
      sprintf(outbuffer, "set loglevel to %d submitted\n", n_log_level);
      iwrite(fd, outbuffer, strlen(outbuffer));

      sprintf(outbuffer, "2loglevel %s", log_level);
      if (write(fd_fifo, outbuffer, strlen(outbuffer) + 1) == -1) {
	iwrite(fd, "write error in FIFO\n", 20);
	LOG_PRINT(LOG_WARNING, "write error in FIFO");
      }
      else {
	LOG_PRINT(LOG_INFO, "set loglevel submitted");
      }
    }
    else {
      iwrite(fd, "confserv: wrong or incomplete command\n", 38);
    }
  }
  if (close(fd_fifo) != 0) {
    LOG_PRINT(LOG_WARNING, "write error in FIFO, detected when closing");
  }
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  confserv(): configures the application server (parent process)

  void confserv

  char* command ptr to string with the command

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void confserv(char *command) {
  char outbuffer[OUTBUF_LEN];

  /* the command buffer should have one or two entries: a command and
     an optional argument */
  if (*command == '1') { /* one argument */
    if (strncmp(command + 1, "stop", 4) == 0) {
      run = 0;
      LOG_PRINT(LOG_INFO, "application server stopped");
    }
  }
  else { /* more than one argument, use first two */
    if (strncmp(command + 1, "serverip", 8) == 0) {
      strcpy(server_ip, command + 10);
      sprintf(outbuffer, "set serverip to %s", server_ip);
      LOG_PRINT(LOG_INFO, outbuffer);
    }
    else if (strncmp(command + 1, "timeout", 7) == 0) {
      strcpy(refdb_timeout, command + 9);
      n_refdb_timeout = atoi(refdb_timeout);
      sprintf(outbuffer, "set timeout to %d seconds", n_refdb_timeout);
      LOG_PRINT(LOG_INFO, outbuffer);
    }
    else if (strncmp(command + 1, "logfile", 7) == 0) {
      strcpy(log_file, command + 9);
      sprintf(outbuffer, "set logfile to %s", log_file);
      LOG_PRINT(LOG_INFO, outbuffer);
      n_reopen_log = 1; /* signal the log fn to open new log file */
    }
    else if (strncmp(command + 1, "logdest", 7) == 0) {
      strcpy(log_dest, command + 9);
      n_log_dest = atoi(log_dest);
      sprintf(outbuffer, "set logdest to %d", n_log_dest);
      LOG_PRINT(LOG_INFO, outbuffer);
    }
    else if (strncmp(command + 1, "loglevel", 8) == 0) {
      strcpy(log_level, command + 10);
      n_log_level = atoi(log_level);
      sprintf(outbuffer, "set loglevel to %d", n_log_level);
      LOG_PRINT(LOG_INFO, outbuffer);
    }
  }
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  connect_to_db(): establishes a connection with the mysql database 
  
  MYSQL* connect_to_db Returns ptr to MYSQL structure if successful,
                       NULL if failed      

  MYSQL *mysql ptr to a MYSQL structure                         

  char *username string containing the name of the current user

  char *passwd string containing the database access password of
               the current user

  char *server_ip string containing the IP address of the database
                  server

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
MYSQL* connect_to_db(MYSQL *mysql, char *username, char *passwd, char *server_ip) {
  MYSQL *connection;
  
  return connection;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  viewstat(): executes client command viewstat

  void viewstat

  int fd file descriptor of socket

  char *username string containing the name of the current user

  char *passwd string containing the database access password of
               the current user

  char *server_ip string containing the IP address of the database
                  server

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void viewstat(int fd, char *username, char *passwd, char *server_ip) {
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  listdb(): implements the client command listdb

  void listdb

  int fd file descriptor of socket

  char *argument command argument (or NULL if none)
                 the argument can be any valid SQL regular expression

  char *username the database username

  char *passwd the database password

  char *server_ip string containing the IP address of the database
                  server

  int select if 1, answers selectdb command, if 0, answers listdb command

  This function has no return value

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void listdb(int fd, char *argument, char *username, char *passwd, char *server_ip, int select) {
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  createdb(): implements the client command createdb

  int createdb returns 0 if error, 1 if successful 

  int fd file descriptor of socket

  char *argument command argument (or NULL if none)

  char *username the mysql username

  char *passwd the mysql password

  char *server_ip string containing the IP address of the database
                  server

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
int createdb(int fd, char *argument, char *username, char *passwd, char *server_ip) {
  return 1;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  deletedb(): implements the client command deletedb

  int deletedb returns 0 if failed, 1 if successful

  int fd file descriptor of socket

  char *argument command argument (or NULL if none)
                 the argument can be any valid SQL regular expression

  char *username the mysql username

  char *passwd the mysql password

  char *server_ip string containing the IP address of the database
                  server

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
int deletedb(int fd, char *argument, char *username, char *passwd, char *server_ip) {
  return 1;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  adduser(): implements the client command adduser

  int adduser returns 0 if failed, 1 if successful

  int fd file descriptor of socket

  int optind current index for *inargv array

  int inargc number of arguments in *inargv array

  char** inargv array of arguments

  char *username the mysql username

  char *passwd the mysql password

  char *current_db the currently selected database

  char *user_host string containing the name of the host from which
                  username will access the database. This is actually
                  the host on which the refdbs runs that username
                  will use to access the database. if user_host is
                  NULL, it will be set to localhost

  char *server_ip string containing the IP address of the database
                  server

  int n_remove if 0, access wil be granted. if 1, access will be revoked

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
int adduser(int fd, int optind, int inargc, char **inargv, char *username, char *passwd, char *current_db, char *user_host, char *server_ip, int n_remove) {
  return 1;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  getfoo(): implements the client commands getau, getkw, and getjo

  void getfoo

  int fd file descriptor of socket

  char *argument command argument (or NULL if none)
                 the argument is a search expression

  char *username the database username

  char *passwd the database password

  char *current_db the currently selected database

  int type the type of user command 0 = getau, 1 = getkw, 2 = getjo,
                                    3 = getjf, 4 = getj1, 5 = getj2

  int all if 1, return all synonyms of a journal name query

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void getfoo(int fd, char *argument, char *username, char *passwd, char *current_db, char* server_ip, int type, int all) {
}







