/* risdb.c: functions to write RIS datasets to a database */
/* hoenicka_markus@compuserve.com 3-26-00 */
/* $Id: risdb.c,v 1.20 2000/08/11 06:48:47 markus Exp markus $ */

/* ToDo: think about consolidating int variables that are used as switches */
/* ToDo: newer versions of mySQL support indices larger than int.
   Several variables need to be adapted to support this */


#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <syslog.h> /* priority levels of log messages */

#include <mysql/mysql.h>
#include "risdb.h"
#include "tokenize.h"
#include "readris.h"
#include "connect.h"
#include "strfncs.h"

extern int n_log_level; /* level up to which messages are logged */

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  dotify_journal(): adds periods after abbreviated names in JO/JA
                    The modified string finally ends up in the same
                    location as the passed string. This is ok as the
                    modification in no case increases the length of
                    the string more than 1 char (it will actually
                    decrease the length of the string if it contains
                    trailing or leading or consecutive whitespace).
                    Each token will be compared with a wordlist in
                    refdb. If a match is found, a space is used as
                    separator. If no match is found, the word is
                    considered an abbreviation and gets a dot
                    appended.

  char* dotify_journal returns pointer to the modified string. Returns
                    NULL if the argument is NULL or an empty string
                    or if we're out of memory.

  char* journal pointer to the string containing the abbreviated
                    journal. IMPORTANT: The array holding the
                    abbreviated journal must be allocated to have
                    one char more than the length of the string incl
                    the terminating \0 (i.e. strlen(JA) + 2).

  MYSQL* connection pointer to a data structure for a previously
                    established MYSQL session. The caller is
                    responsible to establish this connection and
                    to take it down again after this function
                    returns.

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
char* dotify_journal(char* journal, MYSQL* connection) {
  return journal;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  process_ris_set(): adds a given RIS dataset to the database

  int process_ris_set returns 0 if failed, 1 if successfully added,
                              2 if successfully replaced

  char* set string holding a RIS dataset

  MYSQL* connection pointer to a data structure for a previously
                    established MYSQL session. The caller is
                    responsible to establish this connection and
                    to take it down again after this function
                    returns.

  int replace_ref if set to 1, this fn tries to replace an existing
                    entry with the same ID. If set to 0, it adds
                    the reference. If set to 2, it will just update
                    an existing entry with the personal information
                    AV, N1, RP

  char *set_owner string denoting the user who adds/owns this reference

  int fd file descriptor of socket

  int n_keep_id if 1, any existing reference ID will be saved in U5

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/* this is a gigantic function but I don't want to split it and thus 
   introduce too many function calls for performance reasons. My
   apologies to anyone trying to debug or modify it */

/* migration to mstr* done where necessary */
int process_ris_set(char* set, MYSQL* connection, int replace_ref, char* set_owner, int fd, char* current_db, int n_keep_id) {

    return 1; /* successfully added */
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  find_journal(): matches strings against entries in t_periodical to
                  find existing entries

  int find_journal returns the ID of a t_periodical set if a match is
                  found; returns -1 if no match is found or if an
                  error occurs

  int level indicates in which field to search (0 = journal_name, ...
                  3 = journal_custabbrev)

  char* journal_full ptr to a string containing the full name of the
                  journal that we seek, or NULL if not available

  char* journal_abbrev ptr to a string containing the abbreviated
                  name of the journal that we seek, or NULL if not
                  available

  char* journal_custabbrev1 ptr to a string containing the 1st custom
                  abbreviation of the journal that we seek, or NULL
                  if not available

  char* journal_custabbrev2 ptr to a string containing the 2nd custom
                  abbreviation of the journal that we seek, or NULL
                  if not available

  MYSQL *connection ptr to current database connection structure

  char* sql_command ptr to a string large enough to hold all queries
                  in this function, e.g. 4096

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
int find_journal(int level, char* journal_full, char* journal_abbrev, char* journal_custabbrev1, char* journal_custabbrev2, MYSQL *connection, char* sql_command) {
    return 1;

}








