/* strfncs.h header for strfncs.c */

/* this is from readline/chardefs.h. */
#ifndef whitespace
#define whitespace(c) (((c) == ' ') || ((c) == '\t'))
#endif

/* this is different from whitespace in readline/chardefs.h */
#define full_whitespace(c) (((c) == ' ') || ((c) == '\t') || ((c) == '\n') || ((c) == '\r'))

/* this defines a log print facility. This prevents that a costly function
   call to log_print() is made just to find out that the log level does
   not call for any actions. Don't use this macro in another expression,
   just put "LOG_PRINT(your_string, level)" on its own line.
   Arguments: char* s  string to print
              int   l  minimum log level to get the string printed*/
#define LOG_PRINT(l,s) if (n_log_level >= l) {log_print(l,s);}

/* the mstr* functions use this value to reallocate memory for an autogrowing string. They will simply reallocate the existing size plus realloc_chunk if the requested size is not larger than that. This prevents that during string assembly where lots of small bits and pieces like commas, quotation marks, and brackets are appended, each one or two-byte increase in size needs an expensive call to realloc(). The higher the value for realloc_chunk, the less realloc() calls are necessary, but we may waste memory */
#define realloc_chunk 512

struct charent {
  int character;
  char entity[16];
};

int is_ip(char *address);

int is_port(char *port);

char *stripwhite(char *string, int mode, int type);

char* strup(char* string);

int compare_ptr(void* ptr_one, void* ptr_two);

char* mstrcat(char* destination, char* source, size_t* dest_len, size_t offset);

char* mstrcpy(char* destination, char* source, size_t* dest_len);

char* mstrncpy(char* destination, char* source, size_t n, size_t* dest_len);

char* mstrdup(char *buffer);

void free_all(void*** ptr_mem);

size_t count_the_flowers(char *buffer, char letter);

void insert_string(char *buffer, char *insert);

char* sgml_entitize(char** buffer, size_t* buffer_len, struct charent* myents);
