/* writeris.c: functions to write RIS datasets and to create DocBook bibliography entries */
/* hoenicka_markus@compuserve.com 4-28-00 */
/* $Id: writeris.c,v 1.8 2000/08/11 06:55:05 markus Exp markus $ */


#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>

#include "mysql/mysql.h"
#include "writeris.h" /* depends on mysql.h */
#include "strfncs.h"
#include "backend-scrn.h"
#include "backend-ris.h"
#include "backend-db31.h"
#include "backend-bibtex.h"
#include "backend-html.h"

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  render_ref(): formats the result of a query

  char* render_ref returns ptr to the buffer if successful, NULL if failed

  char* ref ptr to a buffer created with malloc which will receive
        the output. The calling function must allocate the buffer
        with at least one byte. This function will reallocate the
        buffer as needed. It is essential that the calling function
        uses *ONLY* the return value of this function to reference the
        buffer and *NEVER* the pointer passed to the function as this
        may be invalid after a possible realloc(). The calling function
        is responsible for freeing the memory again.

  size_t* ref_len ptr to a variable holding the allocated length of
        ref. This variable will be updated if a realloc is necessary.

  MYSQL* connection the connection to the database server. Must be
        established and taken down by the calling function.

  MYSQL_RES* mysqlres the result of a previous query that contains
        all refdb_id's of the entries that are to be rendered

  char* format_string string containing the information which fields
        to print

  int ref_format the output format 0 = simple screen rendering,
        1 = RIS format, 2 = DocBook format, 3 = BibTeX format,
        4 = html format

  char* username ptr to string with the current username

 ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
char* render_ref(char* ref, size_t* ref_len, MYSQL* connection, MYSQL_ROW* row, char* format_string, int ref_format, char* username) {
  /* ToDo: handle paper vs. book vs. book article issue */
  /* ToDo: implement BibTeX format */

  return ref;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  prepare_render(): writes a header for the output of a query

  void prepare_render

  char* ref ptr to a buffer which will receive the output.

  char* format_string string containing the information which fields
        to print

  int ref_format the output format 0 = simple screen rendering,
        1 = RIS format, 2 = DocBook format, 3 = BibTeX format

 ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void prepare_render(char* ref, char* format_string, int ref_format) {
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  finish_render(): writes a footer for the output of a query

  char* finish_render returns ptr to ref if successful, NULL if not
                      ref may be reallocated, so after this function
                      returns only the return value is granted to
                      point to the result string

  char* ref ptr to a buffer which will receive the output.

  size_t* ptr_ref_len pointer to variable holding current length of ref

  char* format_string string containing the information which fields
        to print

  int ref_format the output format 0 = simple screen rendering,
        1 = RIS format, 2 = DocBook format, 3 = BibTeX format

 ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
char* finish_render(char* ref, size_t* ptr_ref_len, char* format_string, int ref_format) {
  return ref;
}



