/*
 * $Id: getpgp.cpp,v 1.3 2000/11/15 16:01:42 jt Exp $
 */

#include <windows.h>
#include <shlguid.h>
#include <shlobj.h>
#include <io.h>
#include <fcntl.h>
#include <iostream>
#include <string>

using namespace std;

DWORD GetProgramGroupPath(bool aSystem, string& aProgramGroupPath);
void ParseArgs(int argc, char* argv[], bool& aSystem);
void PrintUsage();

int
main(int argc, char* argv[])
{
	_setmode(_fileno(stdout), _O_BINARY);

	// Parse command line arguments
	bool aSystem = true;
	ParseArgs(argc, argv, aSystem);

	// Get get the program group special folder path
	string aProgramGroupPath;
	DWORD aStatus = GetProgramGroupPath(aSystem, aProgramGroupPath);
	if (aStatus != ERROR_SUCCESS)
	{
		cerr << "GetProgramGroupPath failed with error = " << aStatus << endl;
	}
	else
	{
		cout << aProgramGroupPath << endl;
	}

	return (aStatus == ERROR_SUCCESS) ? 0 : 2;
}

DWORD
GetProgramGroupPath(bool aSystem, string& aProgramGroupPath)
{
	char aPath[MAX_PATH];
	int anId = (aSystem) ? CSIDL_COMMON_PROGRAMS : CSIDL_PROGRAMS;
	LPITEMIDLIST aPathId;
	HRESULT aReturnCode = SHGetSpecialFolderLocation(0, anId, &aPathId);
	if (FAILED(aReturnCode))
	{
		cerr << "SHGetSpecialFolderLocation failed with error = " << aReturnCode << endl;
		return aReturnCode;
	}

	BOOL aStatus = SHGetPathFromIDList (aPathId, aPath);
	if (!aStatus)
	{
		aReturnCode = GetLastError();
		cerr << "SHGetPathFromIDList failed with error = " << aReturnCode << endl;
		return aReturnCode;
	}

	aProgramGroupPath = aPath;

	return aReturnCode;
}

void
ParseArgs(int argc, char* argv[], bool& aSystem)
{
	// Print usage, if appropriate
	if (argc == 1)
	{
		PrintUsage();
		exit(1);
	}

	// Process arguments
	for (int i = 1; i < argc; i++)
	{
		if (strcmp(argv[i], "--system") == 0)
		{
			aSystem = true;
		}
		else if (strcmp(argv[i], "--user") == 0)
		{
			aSystem = false;
		}
		else
		{
			PrintUsage();
			exit(1);
		}
	}
}

void
PrintUsage()
{
	cerr << "usage: getpgp --system | --user" << endl;
}
