#!/bin/bash

# $Id: setup.sh,v 1.10 2001/09/26 14:24:10 jt Exp $

# Set PATH
PATH=/usr/bin:/etc/postinstall/bin

# Remove old done file, if necessary
rm -f /etc/postinstall/$(basename $0).done

# Determine and export CygwinDir
CygwinRootMountPointRegKey='SOFTWARE\Cygnus Solutions\Cygwin\mounts v2\/\native'
CygwinRootDir=$(regtool get "HKCU\\$CygwinRootMountPointRegKey" 2>/dev/null)

if [ -z "$CygwinRootDir" ]
then
	CygwinRootDir=$(regtool get "HKLM\\$CygwinRootMountPointRegKey"
		2>/dev/null)
fi

export CygwinDir=$(cygpath -w $CygwinRootDir)

# On Windows NT/2000, set/modify the Cygwin environment variables
if [[ $(uname -s) == CYGWIN_NT* ]]
then
	# Variable definitions for environment setup
	if [ isadmin ]
	then
		RegEnvironmentName='HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment'
	else
		RegEnvironmentName='HKCU\Environment'
	fi

	# Set CygwinDir
	RegCygwinDirName="$RegEnvironmentName\\CygwinDir"
	RegCygwinDirValue="$CygwinDir"
	regtool -s set "$RegCygwinDirName" "$RegCygwinDirValue"

	# Set CYGWIN
	RegCygwinName="$RegEnvironmentName\\CYGWIN"
	RegCygwinValue='binmode notty ntsec'
	regtool -s set "$RegCygwinName" "$RegCygwinValue"

	# Set MAKE_MODE
	RegMakeModeName="$RegEnvironmentName\\MAKE_MODE"
	RegMakeModeValue='UNIX'
	regtool -s set "$RegMakeModeName" $RegMakeModeValue

	# Prepend Cygwin bins to PATH, if necessary
	RegPathName="$RegEnvironmentName\\Path"
	RegPathValue=$(regtool get "$RegPathName" 2>/dev/null)
	echo $RegPathValue |
		egrep -i -q '%CygwinDir%\\usr\\local\\bin|%CygwinDir%\\bin'
	if [ $? -ne 0 ]
	then
		RegPathValue='%CygwinDir%\usr\local\bin;%CygwinDir%\bin;'"$RegPathValue"
		regtool set "$RegPathName" "$RegPathValue"
	fi

	# Send WM_SETTINGCHANGE message indicating that environment has changed.
	sndwsc
fi

# Exit if the Cygwin Program Group already exists
if [ -d "$CygwinGroupPosixDir" ]
then
	exit 0
fi

# Variable definitions necessary for program group creation
if [[ $(uname -s) == CYGWIN_NT* ]]
then
	if [ isadmin ]
	then
		CygwinGroupBaseDir=$(getpgp --system)
	else
		CygwinGroupBaseDir=$(getpgp --user)
	fi
else
	CygwinGroupBaseDir=$(getpgp --user)
fi
CygwinGroupDir="$CygwinGroupBaseDir\\Cygwin"
CygwinGroupPosixDir=$(cygpath -u "$CygwinGroupDir")

# Create the Cygwin Program Group
mkdir "$CygwinGroupPosixDir"

# Exit if Cygwin Program Group creation failed
if [ $? -ne 0 ]
then
	exit 1
fi

# Variable definitions necessary for shortcut creation
SystemBaseDir='%windir%'
if [[ $(uname -s) == CYGWIN_NT* ]]
then
	SystemDir="$SystemBaseDir\\system32"
	TelnetDir=$SystemDir
else
	SystemDir="$SystemBaseDir\\system"
	TelnetDir=$SystemBaseDir
fi

# Create the rxvt shortcut
RxvtHost=$(uname -n | tr 'A-Z' 'a-z')
RxvtCmd='%CygwinDir%\usr\local\bin\run.exe'
RxvtArgs="rxvt -sl 512 -sr -fn courier -title $RxvtHost -e bash --login"
RxvtShorcut="$CygwinGroupDir\\rxvt.lnk"
RxvtDir='%HOMEDRIVE%%HOMEPATH%'
RxvtIcon="$SystemDir\\shell32.dll"
RxvtIndex=65

mksc --cmd "$RxvtCmd" --args "$RxvtArgs" --shortcut "$RxvtShorcut" --dir "$RxvtDir" --icon "$RxvtIcon" --index "$RxvtIndex"

# Create the bash shortcut
BashCmd='%CygwinDir%\bin\bash.exe'
BashArgs='--login'
BashShorcut="$CygwinGroupDir\\bash.lnk"
BashDir='%HOMEDRIVE%%HOMEPATH%'
BashIcon="$SystemDir\\shell32.dll"
BashIndex=2

mksc --cmd "$BashCmd" --args "$BashArgs" --shortcut "$BashShorcut" --dir "$BashDir" --icon "$BashIcon" --index "$BashIndex"

# Create the rlogin shortcut (sample)
RloginHost=prodserv
RloginCmd='%CygwinDir%\usr\local\bin\run.exe'
RloginArgs="rxvt -sl 512 -sr -fn courier -title $RloginHost -e rlogin $RloginHost"
RloginShorcut="$CygwinGroupDir\\$RloginHost.lnk"
RloginDir='%HOMEDRIVE%%HOMEPATH%'
RloginIcon="$TelnetDir\\telnet.exe"
RloginIndex=0

mksc --cmd "$RloginCmd" --args "$RloginArgs" --shortcut "$RloginShorcut" --dir "$RloginDir" --icon "$RloginIcon" --index "$RloginIndex"

# Remind Windows 95/98/ME user to complete the manual steps of their setup
if [[ $(uname -s) != CYGWIN_NT* ]]
then
	echo "Cygwin Windows 95/98/ME setups are only semiautomatic."
	echo "Please perform the steps enumerated in Cygwin Windows"
	echo "95/98/ME Extra Setup Instructions to complete the setup."
	echo
	echo "Press return to continue."
	read dummy
	exit 0
fi

# Exit with successful status
exit 0
