#from Cython.Compiler import ExprNodes, Nodes, ModuleNode, Main
#from Cython.Compiler.Main import CompilationOptions, default_options, CompilationResult
import ExprNodes, Nodes, ModuleNode, Main
#from Main import CompilationOptions, default_options, CompilationResult
import os, re

def nodify_while(tree):
    assert tree[0] == 'while'
    test = nodify(tree[1])
    if 'else' in tree:
        ind = tree.index('else')
        body = nodify_block(tree[2:ind])
        else_clause = nodify_block(tree[(ind+1):])
    else:
        body = nodify(tree[2:])
        else_clause = None
    return Nodes.WhileStatNode( None, 
                                condition = test, body = body, 
                                else_clause = else_clause)

int_re = re.compile('[-+]?[0-9]+')

def nodify(tree):
    if isinstance(tree, (list, tuple)):
        funct = tree[0]
        assert isinstance(funct, str)
        if funct in ExprNodes.binop_node_classes:
            assert len(tree) == 3
            return ExprNodes.binop_node( None, tree[0], nodify(tree[1]), nodify(tree[2]))
        elif funct == 'def':
            assert len(tree) >= 4
            return Nodes.DefNode( None, name = tree[1], args = [nodify_arg(arg) for arg in tree[2]], 
                                  star_arg = None, starstar_arg = None,
                                  doc = None, body = nodify_block(tree[3:]))
        elif funct == 'print':
            return Nodes.PrintStatNode( None, 
                                       args = [nodify(arg) for arg in tree[1:]], ends_with_comma = 0)
        elif funct == 'tuple':
            return ExprNodes.TupleNode(None, args = [nodify(arg) for arg in tree[1:]])
        else:
            return ExprNodes.SimpleCallNode(None, function = nodify(funct), args = [nodify(arg) for arg in tree[1:]])
            
    elif isinstance(tree, str):
        if int_re.match(tree):
            return ExprNodes.IntNode(None, value = tree)
        else:
            return ExprNodes.NameNode(None, name = tree)
    elif isinstance(tree, Nodes.Node):
    	return tree
    else:
        print "tree:", tree
        assert False

def nodify_block(tree):
    if len(tree) == 1:
        return nodify(tree[0])
    else:
        return Nodes.StatListNode( None, stats = [nodify(subtree) for subtree in tree] )
    
def nodify_arg(arg):
    assert isinstance(arg, str)
    base_type = Nodes.CSimpleBaseTypeNode(None, 
        name = None, module_path = [],
        is_basic_c_type = 0, signed = 1,
        longness = 0, is_self_arg = 0)
    declarator = Nodes.CNameDeclaratorNode( None, name = arg, cname = None)
    return Nodes.CArgDeclNode(None,
        base_type = base_type,
        declarator = declarator,
        not_none = 0,
        default = None,
        kw_only = 0)


#n = nodify(['*', 'i', ['+', 'x', 'y']])
#print n.display(0, 3)
#n = nodify(['def', 'foo', ['i', 'j'], ['print', ['+', 'i', 'j']]])
#print n.display(0, 3)

#module_node = ModuleNode.ModuleNode( None, doc = None, body = n, full_module_name = 'bar')


#options = CompilationOptions(default_options, 
                    #use_listing_file = 0,
                    #include_path = [],
                    #output_file = 'bar.cpp',
                    #cplus = True,
                    #generate_pxi = 0)

#result = CompilationResult()
#cwd = os.getcwd()
#result.c_file = os.path.join(cwd, options.output_file)

#context = Main.Context([])

#scope = context.find_module('bar', pos = ('', 1, 0), need_pxd = 0)
#module_node.process_implementation(scope, options, result)
