#include "Rectangle.h"

Rectangle::Rectangle(int x0, int y0, int x1, int y1)
  : x0(x0), y0(y0), x1(x1), y1(y1) { }

Rectangle::~Rectangle() { }

int Rectangle::getLength() {
  int L = this->x1 - this->x0;
  return (L >= 0) ? L : -L;
}

int Rectangle::getHeight() {
  int H = this->y1 - this->y0;
  return (H >= 0) ? H : -H;
}
int Rectangle::getArea() {
  return this->getLength() * this->getHeight();
}

void Rectangle::move(int dx, int dy) { 
  this->x0 += dx; this->x1 += dx;
  this->y0 += dy; this->y1 += dy;
}
