#!/usr/bin/python3

from distutils.core import setup
from distutils.extension import Extension
from Cython.Distutils import build_ext

setup(
    name = 'pep420test',
    description = 'Package For Testing Cython PEP-420 compliance',
    long_description = """\
Removing __init__.py from firstlevel and from secondlevel packages \
stops Cython from functioning correctly, while this is normal for python 3.3.
""",

    packages = [
        'firstlevel.secondlevel.mydearpackage'
        ],
    ext_modules = [
        Extension(
            "firstlevel.secondlevel.mydearpackage.test",
            ["firstlevel/secondlevel/mydearpackage/test.pyx"]
            )
        ],
    cmdclass = {'build_ext': build_ext},
    package_data = {'firstlevel.secondlevel.mydearpackage': ['*.pxd']},
    )
