import pandas as pd
import numpy as np
import gc
import operator
from collections import defaultdict

from test import do_nothing_typed
from test import do_nothing_but_copy
from test import do_nothing


def gc_obj_hist():
    """
    Returns a sorted map from type to the counts
    of in memory objects with the type
    """
    hst = defaultdict(lambda: 0)
    for v in gc.get_objects():
        hst[type(v)] += 1
    l = sorted(hst.iteritems(), key=operator.itemgetter(1), reverse=True)
    return l


def test1(n=10000):
    s = pd.Series([np.random.randn(10) for i in range(n)])
    for i in range(n):
        do_nothing(s[i])
    print "Top 5 object types after test 1: " + str(gc_obj_hist()[:5])


def test2(n=10000):
    s = pd.Series([np.random.randn(10) for i in range(n)])
    for i in range(n):
        do_nothing_typed(s[i])
    print "Top 5 object types after test 2: " + str(gc_obj_hist()[:5])


def test3(n=10000):
    s = pd.Series([np.random.randn(10) for i in range(n)])
    for i in range(n):
        do_nothing_but_copy(s[i])
    print "Top 5 object types after test 3: " + str(gc_obj_hist()[:5])


def test4(n=10000):
    s = pd.Series([np.random.randn(10) for i in range(n)])
    for i in range(n):
        do_nothing_but_copy(np.array(s[i]))
    print "Top 5 object types after test 4: " + str(gc_obj_hist()[:5])

if __name__ == "__main__":
    n = 100000

    test1(n)

    test2(n)

    test3(n)

    test4(n)
