package DateTime::Decorated::OrderedMath;

use Data::Dumper;

sub add_lsb {
    my ($self, $duration) = @_;
	my %deltas = $duration->deltas;
    foreach (qw/nanoseconds seconds minutes hours days months years/) {
        $self->add( $_ => $deltas{$_} ) if $deltas{$_}
    }
    return $self;
}

sub add_msb {
    my ($self, $duration) = @_;
	my %deltas = $duration->deltas;
    foreach (reverse qw/nanoseconds seconds minutes hours days months years/) {
        $self->add( $_ => $deltas{$_} ) if $deltas{$_}
    }
    return $self;
}


1;