my $decorated_class;

use DateTime::Duration;
use DateTime::Decorated
	with => [ 'OrderedMath', 'ISO8601' ],
	as   => 'Decorated';


my $duration = DateTime::Duration->new(months => -1, days => -15);

$today1 = Decorated->new( year => 2004 );
$today2 = $today1->clone;
$today3 = $today1->clone;

$today1->add_lsb( $duration );
$today2->add_msb( $duration );
$today3->add( $duration );

print 'LSB:      '.$today1->datetime."\n";
print 'MSB:      '.$today2->datetime."\n";
print 'Standard: '.$today2->datetime."\n";

my $parsed = Decorated->parse('2005-06-01');

print $parsed->datetime . "\n";

print ref($parsed) . "\n";
