CREATE DATABASE `playground`;
USE `playground`;

CREATE TABLE `company` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(64) NOT NULL,
  PRIMARY KEY  (`id`)
);

CREATE TABLE `employee` (
  `id` int(11) NOT NULL auto_increment,
  `company_id` int(11) NOT NULL,
  `name` varchar(64) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `company_id` (`company_id`),
  CONSTRAINT `employee_fk` FOREIGN KEY (`company_id`) REFERENCES `company` (`id`)
);

CREATE TABLE `email_address` (
  `id` int(11) NOT NULL auto_increment,
  `employee_id` int(11) NOT NULL,
  `email` varchar(128) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `employee_id` (`employee_id`),
  CONSTRAINT `email_address_fk` FOREIGN KEY (`employee_id`) REFERENCES `employee` (`id`)
);

INSERT INTO `company` (`id`, `name`) VALUES
  (1,'Test Co.');

INSERT INTO `employee` (`id`, `company_id`, `name`) VALUES 
  (1,1,'Joe Smith'),
  (2,1,'Jack Smith'),
  (3,1,'Joseph Smith'),
  (4,1,'Joan Smith'),
  (5,1,'Julie Smith');

INSERT INTO `email_address` (`id`, `employee_id`, `email`) VALUES 
  (1,1,'joe@smith.com'),
  (2,1,'mrsmith@perl.org'),
  (3,5,'julie@smith.com'),
  (4,3,'bug@catalystframework.org');

