<?php
    /* change_dbmail_pass
     *
     * $Id: options.php,v 1.5 2004/07/21 14:28:46 indiri69 Exp $
     */

    define('SM_PATH', '../../');
    require_once (SM_PATH . 'include/validate.php');
    require_once (SM_PATH . 'functions/page_header.php');
    require_once (SM_PATH . 'functions/imap.php');
    require_once (SM_PATH . 'functions/prefs.php');
    require_once (SM_PATH . 'functions/global.php');
    require_once (SM_PATH . 'functions/i18n.php');

    sqgetGlobalVar('plugin_change_dbmail_pass', $plugin_change_dbmail_pass, SQ_POST);

    $messages = array();
    if (isset($plugin_change_dbmail_pass)) {
        sqgetGlobalVar('cp_oldpass', $cp_oldpass, SQ_POST);
        sqgetGlobalVar('cp_newpass', $cp_newpass, SQ_POST);
        sqgetGlobalVar('cp_verify',  $cp_verify,  SQ_POST);
        bindtextdomain('change_dbmail_pass', SM_PATH . 'plugins/change_dbmail_pass/locale');
        textdomain('change_dbmail_pass');
        $messages = change_dbmail_pass_check();
        bindtextdomain('squirrelmail', SM_PATH . 'locale');
        textdomain('squirrelmail');
    }

    displayPageHeader($color, 'None');

    bindtextdomain('change_dbmail_pass', SM_PATH . 'plugins/change_dbmail_pass/locale');
    textdomain('change_dbmail_pass');
?>
    <table width="100%" cellpadding="2" cellspacing="2" border="0">
        <tr><td bgcolor="<?php echo $color[0] ?>">
                <center><b><?php echo _("Change Password") ?></b></center>
        </td></tr>
        <tr><td>
<?php
    if (count($messages)) {
        foreach ($messages as $line) {
            echo htmlspecialchars($line) . "<br>\n";
        }
        echo "</td></tr>\n";
        echo "<tr><td>\n";
    }
?>
            <form method="post" action="<?php echo $PHP_SELF ?>">
            <table align="center">
<?php
    $values = array(_("Old Password")        => 'cp_oldpass',
                    _("New Password")        => 'cp_newpass',
                    _("Verify New Password") => 'cp_verify');
    foreach($values as $key=>$value) {
?>
                <tr>
                    <th align="right"><?php echo $key; ?></th>
                    <td>
                        <input type="password" name="<?php echo $value; ?>" size="20">
                    </td>
                </tr>
<?php } ?>
                <tr><td align="center" colspan="2">
                    <input type="submit" value=<?php echo _("Submit"); ?> name="plugin_change_dbmail_pass">
                </td></tr>
            </table>
            </form>
        </td></tr>
    </table>
</body></html>
<?php
    bindtextdomain('squirrelmail', SM_PATH . 'locale');
    textdomain('squirrelmail');

function change_dbmail_pass_check($debug = 0) {
    global $cp_oldpass, $cp_newpass, $cp_verify;
    global $plugin_change_dbmail_pass;

    sqgetGlobalVar('key', $key, SQ_COOKIE);
    sqgetGlobalVar('onetimepad', $onetimepad, SQ_SESSION);
    $messages = array();
    $password = OneTimePadDecrypt($key, $onetimepad);

    if ($cp_oldpass == '') {
        $messages[] = _("You must type in your old password.");
    }
    if ($cp_newpass == '') {
        $messages[] = _("You must type in a new password.");
    }
    if ($cp_verify  == '') {
        $messages[] = _("You must also type in your new password in the verify box.");
    }
    if ($cp_newpass != '' && ($cp_verify != $cp_newpass)) {
        $messages[] = _("Your new password doesn't match the verify password.");
    }
    if ($cp_oldpass != '' && ($cp_oldpass != $password)) {
        $messages[] = _("Your old password is not correct.");
    }
    if (count($messages)) {
        $return = $messages;
    } else {
        $return = change_dbmail_pass_go($password, $debug);
    }
    return $return;
}

function change_dbmail_pass_go($password, $debug) {
    include_once(SM_PATH . 'plugins/change_dbmail_pass/settings.php');

    global $username;
    global $cp_newpass, $key, $onetimepad;

    sqgetGlobalVar('base_uri', $base_uri, SQ_SESSION);
    $messages = array();

    if ($debug) {
        $messages[] = _("Connecting to DBMail Server");
    }
    
    $db_conn = pg_connect("dbname=$dbmail_database user=$dbmail_username password=$dbmail_password");
    if (!$db_conn) {
        $messages[] = _("ERROR:") .  "$errstr ($errno)";
        return $messages;
    }

    $res = pg_query($db_conn, "begin; select * from users where userid = '$username' and passwd = '$password' for update;");
    if(pg_num_rows($res) != 1)
    {
        $messages[] = _("ERROR:") . pg_last_error($db_conn) ;
        return $messages;
    }

    $res2 = pg_query($db_conn, "update users set passwd = '$cp_newpass' where userid = '$username' and passwd = '$password'");
    if(pg_affected_rows($res2) != 1)
    {
	pg_query($db_conn, "rollback");
        $messages[] = _("ERROR: Rollback Transaction due to wrong number of rows being updated: ") . pg_affected_rows($res2) ;
        return $messages;
    }
    else
	pg_query($db_conn, "commit");


    $messages[] = _("Password changed successfully.");

    // Write new cookies for the password
    $onetimepad = OneTimePadCreate(strlen($cp_newpass));
    $key = OneTimePadEncrypt($cp_newpass, $onetimepad);
    sqsession_register($onetimepad, 'onetimepad');
    setcookie('key', $key, 0, $base_uri);

    return $messages;
}
?>
