#!/bin/sh -e

VERSION=$2
TAR=../jena-iri_$VERSION.orig-iri.tar.gz
DIR=jena-iri-$VERSION
TAG=$(echo "jena-iri-$VERSION" | sed -re's/~(alpha|beta|incubating)/-\1/')

svn export http://svn.apache.org/repos/asf/incubator/jena/Jena2/IRI/tags/${TAG} $DIR
GZIP=--best tar -c -z -f $TAR --exclude '*.jar' --exclude '*.class' -C $DIR .
rm -rf $DIR ../$TAG

TOP_TAG=jena-top-0-incubating
TOP_TAR=../jena-iri_$VERSION.orig.tar.gz
TOP_DIR=jena-top-$VERSION
svn export https://svn.apache.org/repos/asf/incubator/jena/Jena2/JenaTop/tags/jena-top-0-incubating/ $TOP_DIR
rm -rf $TOP_DIR/trunk
GZIP=--best tar -c -z -f $TOP_TAR --exclude '*.jar' --exclude '*.class' -C $TOP_DIR .
rm -rf $TOP_DIR ../$TOP_TAG

