#!/usr/bin/perl

#       .Copyright      (C) 2000 Dubrice, LLC
#       .Created:       04/25/2000
#       .Contactid:     <webwiz@atlcon.net>
#       .Url:           http://www.atlcon.net
#       .Developed by:  Atl-Connect Internet Services
#       .Written by:    Eric Longman
#
#	.Revision History:
#
#	1.10 - 2000 AUG 09 - Eric Longman
#	Revised to work properly with OpenSRS Client V2.03
#
#
#       This program is free software; you can redistribute it and/or
#       modify it under the terms of the GNU General Public License as
#       published by the Free Software Foundation; either version 2 of
#       the License, or (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful, but
#       WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#       General Public License for more details.
#
#       You should have received a copy of the GNU General Public License along
#       with this program; if not, write to the Free Software Foundation,
#       Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


use vars qw(
	    %in $cgi $path_templates %actions $action %cc_types $Client
	   );

# pull in conf file with defined values
# XXX NOTE XXX Update this configuration file
BEGIN {
    do "c:/inetpub/opensrs/etc/OpenSRS.conf";
}

use lib $PATH_LIB;
do "$PATH_LIB/cgi-lib.pl";

use IO::Socket;

# global defines
my $cgi = $ENV{SCRIPT_NAME};
my $path_templates = "$PATH_TEMPLATES/whois";
my $flag_header_sent = 0;   # whether html header has been sent

start_up();

# read in the form data
ReadParse();

my $domain = $in{domain};

show_whois();

exit;

# show login page for non-secure users
sub show_whois {

   my (%HTML);
   $HTML{CGI} = $cgi;

   if ( $domain ne "" ) {
	  # Only attempt to retrieve the whois data
	  # if a domain was actually given to us
	  
	  # Set up the remote connection
	  $remote = IO::Socket::INET->new( Proto => "tcp",
		 PeerAddr => "whois.opensrs.net",
		 PeerPort => "whois(43)",
		 );

	  unless ($remote) { die "cannot connect to whois server" }
	
	  $remote->autoflush(1);

	  # Send the query to the whois server
	  print $remote "$domain";

	  # Format results for output
	  $strResult = "<hr><strong>WHOIS information for $domain:</strong><br><br>\n";
	  $strResult .= "<code>";
	  while (<$remote>) 
	  { 
		 $strResult .= "$_<br>\n";
	  }
	  $strResult .= "</code>";
   
	  # Close down our session with the whois server
	  close ($remote);
   }

   # Set the output element
   $HTML{WHOISINFO} = $strResult;

   # Merge with template
   print_form("$path_templates/whois.html",\%HTML);

}

##########################################################################
# substitute values on the specified template and print it to the client

# an optional 'type' arg can be passed: 'framed' specifies to pull in base.html
# as the outer frame and the given template as the inner frame
# 'single' specifies to use the given template alone
# the default behavior is 'framed'
sub print_form {
	
	my ($type,$content);

	print_header();

	my @args = @_;
	my ($template,$HTML) = @args[0,1];
	if ($args[2]) { $type = $args[2] }
	else { $type = 'framed' }

	if ($type eq 'framed') {
	$HTML->{CONTENT} = get_content("$template",$HTML);
	
	open (FILE, "<$path_templates/base.html") or die "Couldn't open $path_templates/base.html: $!\n";
	while (<FILE>) {
		s/{{(.*?)}}/$HTML->{$1}/g;
		$content .= $_;
	}
	close FILE;
	} else {
	open (FILE, "<$template") or die "Couldn't open $template: $!\n";
	while (<FILE>) {
		s/{{(.*?)}}/$HTML->{$1}/g;
		$content .= $_;
	}
	close FILE;
	}
	print $content;
		
}

sub start_up {

	# print error to the page
	select (STDOUT); $| = 1;
	open (STDERR, ">&STDOUT") or die "Can't dump stdout: $!\n";
	select (STDERR); $| = 1;
	select (STDOUT);

}

###########################################################################
# print an html header
sub print_header {
	if (not $flag_header_sent) {
	print "Content-type:  text/html\n\n";
	$flag_header_sent = 1;
	} 
}

####################################################
# grab the contents of a template, substitute any supplied values, and return
# the results
sub get_content {
	
	my $content;
	
	my ($template,$HTML) = @_;
	open (FILE, "<$template") or die "Couldn't open $template: $!\n";
	while (<FILE>) {
	s/{{(.*?)}}/$HTML->{$1}/g;
	$content .= $_;
	} 
	close FILE;
	
	return $content;
	
}
