package oosample.converter ;
/*************************************************************************
 *
 *      Greatly Adapted from FirstConnection
 *     
 *************************************************************************/

import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.lang.XComponent;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.XComponentContext;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.bridge.XBridge;
import com.sun.star.connection.XConnector;
import com.sun.star.connection.XConnection;


public class DocConverter extends java.lang.Object {

    private XComponentContext xRemoteContext = null;
    private  XMultiComponentFactory xRemoteServiceManager = null;
    private com.sun.star.frame.XComponentLoader officeComponentLoader;
    XBridge bridge = null ;
    private String stringUrl ;
    private String con ; 
    
    public static void main(String[] args) {
        DocConverter fc = new DocConverter("socket,host=192.168.188.71,port=8100");
        try {
            fc.useConnection();
            System.out.println("About to load object");
            Object toBeStored = fc.loadDocument(args[0]) ;
            System.out.println("Loaded Object");
            XStorable xstorable = fc.getStorable(toBeStored) ;
            System.out.println("Got sortable");
            fc.saveDoc(xstorable,args[1],args[2]) ;
            System.out.println("Saved Doc");
            fc.release() ;
        }
        catch (java.lang.Exception e){
            e.printStackTrace();
        }
        //finally {
            //System.exit(0);
        //}
    }

    public DocConverter(String con)
    {
            this.con = con ;
    }
    
    public  void useConnection() throws java.lang.Exception {
        try {
                XComponentContext _ctx =
                        com.sun.star.comp.helper.Bootstrap.createInitialComponentContext( null );
                
                xRemoteContext = _ctx ;
                        
                Object x = xRemoteContext.getServiceManager().createInstanceWithContext(
                        "com.sun.star.connection.Connector", xRemoteContext );

                XConnector xConnector = (XConnector )
                        UnoRuntime.queryInterface(XConnector.class, x);
                XConnection connection = xConnector.connect( con);
                if (connection == null)
                        System.out.println("Connection is null");
                x = xRemoteContext.getServiceManager().createInstanceWithContext(
                        "com.sun.star.bridge.BridgeFactory", xRemoteContext);
                XBridgeFactory xBridgeFactory = (XBridgeFactory) UnoRuntime.queryInterface(
                        XBridgeFactory.class , x );
                if (xBridgeFactory== null)
                        System.out.println("bridge factoriy is null");
                        
                bridge = xBridgeFactory.createBridge( "" , "urp", connection , null );
                XComponent xComponent = (XComponent) UnoRuntime.queryInterface(
                        XComponent.class, bridge );
                // get the remote instance                         
                x = bridge.getInstance( "StarOffice.ServiceManager");
                // Query the initial object for its main factory interface
                xRemoteServiceManager = ( XMultiComponentFactory )
                        UnoRuntime.queryInterface( XMultiComponentFactory.class, x );
               // retrieve the component context (it's not yet exported from the office)
               // Query for the XPropertySet interface.
               XPropertySet xProperySet = ( XPropertySet )
                        UnoRuntime.queryInterface( XPropertySet.class, xRemoteServiceManager );
                    
               // Get the default context from the office server.
               Object oDefaultContext =
                        xProperySet.getPropertyValue( "DefaultContext" );
                    
               // Query for the interface XComponentContext.
               XComponentContext xOfficeComponentContext =
                        ( XComponentContext ) UnoRuntime.queryInterface(
                            XComponentContext.class, oDefaultContext );
               // now create the desktop service
               // NOTE: use the office component context here !
               Object oDesktop = xRemoteServiceManager.createInstanceWithContext(
                "com.sun.star.frame.Desktop", xOfficeComponentContext );

                officeComponentLoader = ( XComponentLoader )
                        UnoRuntime.queryInterface( XComponentLoader.class, oDesktop );

                

            String available = (null !=officeComponentLoader ? "available" : "not available");
            System.out.println( "remote ServiceManager is " + available );
        }
        catch( com.sun.star.lang.DisposedException e ) { //works from Patch 1
            xRemoteContext = null;
            throw e;
        }          
    }
    
    /*
    * load the doc 
    */
    public Object loadDocument(String file) throws Exception
    {
            java.io.File f =new java.io.File(file) ;
            stringUrl = f.toURL().toString() ;
            /*if (!stringUrl.startsWith("file://")) 
                    if(stringUrl.startsWith("file:/")) 
                            stringUrl = "file://"+stringUrl.substring("file:/".length());*/


            // loader
            XComponentLoader xcomponentloader = officeComponentLoader ;
            xRemoteServiceManager.createInstanceWithContext(
            "com.sun.star.frame.Desktop", xRemoteContext  );
            // property value
           PropertyValue propertyvalue[] = new PropertyValue[ 1 ];
           // Setting the flag for hidding the open document
           propertyvalue[ 0 ] = new PropertyValue();
           propertyvalue[ 0 ].Name = "Hidden";
           propertyvalue[ 0 ].Value = new Boolean(true);

            // object to store
            System.out.println("loading "+stringUrl);
            Object objectDocumentToStore =
            xcomponentloader.loadComponentFromURL(
            stringUrl, "_blank", 0, propertyvalue );
            System.out.println(objectDocumentToStore);
            return objectDocumentToStore;

    }
    
    /*
    * get Storeable
    */
    public XStorable getStorable(Object toBeStored) throws Exception
    {
                  XStorable xstorable =
                  ( XStorable ) UnoRuntime.queryInterface( XStorable.class,toBeStored );
                  return xstorable ;

    }
    /*
    * Save the doc 
    */
    public void saveDoc(XStorable xstorable,String filterName,String extention) throws Exception
    {
            PropertyValue[] propertyvalue = new PropertyValue[ 2 ];
            // Setting the flag for overwriting
            propertyvalue[ 0 ] = new PropertyValue();
            propertyvalue[ 0 ].Name = "Overwrite";
            propertyvalue[ 0 ].Value = new Boolean(true);
            // Setting the filter name
            propertyvalue[ 1 ] = new PropertyValue();
            propertyvalue[ 1 ].Name = "FilterName";
            propertyvalue[ 1 ].Value = filterName;
            // Appending the favoured extension to the origin document name
            String result  = stringUrl + "." + extention;
            // Storing and converting the document
            xstorable.storeToURL(result, propertyvalue );
            // close 
            XComponent xcomponent =
            ( XComponent ) UnoRuntime.queryInterface( XComponent.class,
            xstorable );
            // Closing the converted document
            xcomponent.dispose();
            

    }
    
    public void release()
        throws Exception
    {
            XComponent xcomponent =
            ( XComponent ) UnoRuntime.queryInterface( XComponent.class,
            bridge );
            // Closing the bridge
            xcomponent.dispose();
            
    }
    
  
}
