package oosample.ui ;
/*
 * Adapted from a VoteDialog example in 
  * http://java.sun.com/docs/books/tutorial/uiswing/learn/example-1dot4/VoteDialog.java
 */
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.text.*;
import java.util.List;
import java.util.ArrayList;
import java.util.*;

public class ConvertDialog extends JPanel implements ActionListener{
    JLabel label;
    JFrame frame;
    String simpleDialogDesc = "File Types";
    JFileChooser fc;
    JButton runButton, chooseDirButton;
    JTextField dirNameTextField = new JTextField(10);
    TypeCheckBox[] checkBoxes;
    JCheckBox   subDirCheckBox;
    private FilenameFilter filter;
    private static final String FILE_SEP = System.getProperty("file.separator");
    // list of extention
    final List  word =new ArrayList() ;
    final List excel = new ArrayList() ;
    final List powerPoint = new ArrayList() ;
    final List images = new ArrayList() ;
    static String host ; // host where oo is running
    static String port ; // port where oo is listening
    
    public ConvertDialog(JFrame frame) {
        super(new BorderLayout());
        // add exstention to word
        word.add("doc");
        word.add("rtf"); 
        word.add("sxw");
        // add exstention to excel
        excel.add("xls");
        excel.add("sxc");
        // add exstention to pp
        powerPoint.add("ppt");
        powerPoint.add("sxi");
        // add exstention to images
        images.add("bmp") ;
        images.add("gif") ;
        images.add("jpg") ;
        images.add("jpeg") ;
        images.add("tiff") ;
        

	fc = new JFileChooser();
	fc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
        this.frame = frame;
        JLabel title;
        
        //Create the components.
        JPanel choicePanel = createSimpleDialogBox();
        title = new JLabel("Click the \"run\" button"
                           + " once you have selected the file type you want to convert.",
                           JLabel.CENTER);
        choicePanel.setBorder(BorderFactory.createEmptyBorder(20,20,5,20));

        //Lay out the main panel.
        add(title, BorderLayout.NORTH);  
        //add(label, BorderLayout.SOUTH);        
        add(choicePanel, BorderLayout.CENTER);
    }

    private JPanel createSimpleDialogBox() {
        final int numCheckBox = 4;
        checkBoxes = new TypeCheckBox[numCheckBox];
	subDirCheckBox = new JCheckBox("include sub directories ?");
        
        final ButtonGroup group = new ButtonGroup();

        runButton = null;
	chooseDirButton = null;
        /* setup the checkboxes */	
        checkBoxes[0] = new TypeCheckBox(
          "<html><font color=red>Word Document</font></html>");
          checkBoxes[0].setExtension(word);

        checkBoxes[1] = new TypeCheckBox(
           "<html><font color=green>Excel Sheet</font></html>");
        checkBoxes[1].setExtension(excel);

        checkBoxes[2] = new TypeCheckBox(
            "<html><font color=blue>Power Point</font></html>");
        checkBoxes[2].setExtension(powerPoint);

        checkBoxes[3] = new TypeCheckBox(
            "<html><font color=maroon>Images</font></html>");
        checkBoxes[3].setExtension(images);

        runButton = new JButton("Run");
	chooseDirButton = new JButton("Choose a directory");
	chooseDirButton.addActionListener(this);
	runButton.addActionListener(this);
        System.out.println("calling createPane");
        return createPane(simpleDialogDesc + ":",
                                        checkBoxes, 
                                        runButton,
                                        chooseDirButton,
                                        dirNameTextField,
                                        subDirCheckBox);                    
        }
    
    private JPanel createPane(String description,
                              JCheckBox[] checkBoxes,
                              JButton runButton,
			      JButton chooseDirButton,
			      JTextComponent dirNameTextField,
			      JCheckBox subDirCheckBox) {
        int numChoices = checkBoxes.length;
        JPanel box = new JPanel();
        JLabel label = new JLabel(description);
	
	JPanel centerBox = new JPanel();
	centerBox.setLayout(new BoxLayout(centerBox, BoxLayout.LINE_AXIS));
	centerBox.add(dirNameTextField);
	centerBox.add(subDirCheckBox);

        box.setLayout(new BoxLayout(box, BoxLayout.PAGE_AXIS));
        box.add(label);

        for (int i = 0; i < numChoices; i++) {
            box.add(checkBoxes[i]);
        }

        JPanel pane = new JPanel(new BorderLayout());
        pane.add(box, BorderLayout.NORTH);
	pane.add(chooseDirButton, BorderLayout.WEST);
	pane.add(centerBox, BorderLayout.CENTER);
        pane.add(runButton, BorderLayout.SOUTH);
        System.out.println("returning pane");
        return pane;
    }

    /**
     * Create the GUI and show it.  For thread safety,
     * this method should be invoked from the
     * event-dispatching thread.
     */
    private static void createAndShowGUI() {
        //Make sure we have nice window decorations.
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
       
        //Create and set up the window.
        JFrame frame = new JFrame("Convert to PDF");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE); 

        //Set up the content pane.
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new GridLayout(1,1));
        contentPane.add(new ConvertDialog(frame));

        //Display the window.
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        if (args.length != 2)
        {
                host = "localhost" ;
                port = "8100" ;
                
        }
        else
        {
                host = args[0] ;
                port = args[1] ;
        }
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                createAndShowGUI();
            }
        });
    }
    
    
    public void actionPerformed(ActionEvent e) {

        //Handle open button action.
        if (e.getSource() == chooseDirButton) {
            int returnVal = fc.showOpenDialog(ConvertDialog.this);

            if (returnVal == JFileChooser.APPROVE_OPTION) {
                File file = fc.getSelectedFile();
		dirNameTextField.setText(file.getAbsolutePath());
                //This is where a real application would open the file.
                //log.append("Opening: " + file.getName() + "." + newline);
            } else {
                //log.append("Open command cancelled by user." + newline);
            }
            //log.setCaretPosition(log.getDocument().getLength());

        //Handle save button action.
        }
	if (e.getSource() == runButton) {
		ArrayList myList = new ArrayList();
		
		for (int i = 0; i < checkBoxes.length; i++)
			if (checkBoxes[i].isSelected())
				myList.addAll(checkBoxes[i].getExtension());
		Object[] ext = myList.toArray();
		FilenameFilter myFilter = new MyFilter(ext);
		System.out.println("should i include subdir="+subDirCheckBox.isSelected());
		List fileList = findFilesFrom(dirNameTextField.getText(), myFilter, subDirCheckBox.isSelected());
		
		System.out.println("this is the number of files i have="+fileList.size());
		
		String filePath;
                // iterate on results
                // prepare the converter
                oosample.converter.DocConverter fc = new oosample.converter.DocConverter("socket,host="+host+",port="+port);
                try
                {
                        fc.useConnection();
                        for (Iterator it = fileList.iterator(); it.hasNext();)
                        {
                                File nextFile = (File)it.next() ;
                                filePath = nextFile.getAbsolutePath();
                                convertFile(fc,filePath);
                                System.out.println(filePath);
                        }
                        // release connection
                        fc.release() ;
                }
                catch (Exception exc)
                {
                        System.out.println("OOOOOOOOOOps");
                        exc.printStackTrace() ;
                }
	}
    }
    
    /**
    * generate a list of files 
    */
    public List findFilesFrom(String dir, FilenameFilter filter, boolean recurse) {
	System.out.println("this is the dir="+dir);
        this.filter = filter;
        List files = new ArrayList();
        scanDirectory(new File(dir), files, recurse);
        return files;
    }
/**
* Scan a directory and check for subdirs
*/
private void scanDirectory(File dir, List list, boolean recurse) {
        String[] candidates = dir.list(filter);
        for (int i = 0; i < candidates.length; i++) {
            File tmp = new File(dir + FILE_SEP + candidates[i]);
            if (tmp.isDirectory()) {
                if (recurse) {
                    scanDirectory(tmp, list, true);
                }
            } else {
                list.add(new File(dir + FILE_SEP + candidates[i]));
            }
        }
    }

    /**
      * this is called per file to convert and converts the file to a pdf with the origianl
      * name + .pdf at the end 
      */
    private void convertFile( oosample.converter.DocConverter fc, String fullPath)
        throws Exception
    {
            Object toBeStored = fc.loadDocument(fullPath) ;
            com.sun.star.frame.XStorable xstorable = fc.getStorable(toBeStored) ;
            String exten = fullPath.substring(fullPath.lastIndexOf(".")+1).toLowerCase() ;
            String conv  = null;
            if (word.contains(exten))
                    conv = "writer_pdf_Export" ;
            else if (excel.contains(exten))
                    conv = "calc_pdf_Export" ;
            else if (powerPoint.contains(exten))
                    conv = "impress_pdf_Export" ;
            else if (images.contains(exten))
                    conv = "draw_pdf_Export" ;
            if (conv != null)
                    fc.saveDoc(xstorable,conv,"pdf") ;
            else
                   System.out.println("not sure what happened here") ;
    }
}


