package oosample.ui ;
import java.io.FilenameFilter;
import java.io.File;


public class MyFilter implements FilenameFilter{
	
	Object[] mySuf;
        /**
        * Hold the suffixes that we need 
        */
	public MyFilter (Object[] suf)
	{
		mySuf = suf;
	}
	
        /** 
          * evaluate is a file extenstion ends with one of our suffx 
          */
	protected boolean endsWithSuffix (File f)
	{
		for (int i = 0; i < mySuf.length; i++)
		{
			String tempString = ((String)mySuf[i]).toLowerCase();
			if ( f.isDirectory() || f.getAbsolutePath().endsWith("."+tempString) == true  || f.getAbsolutePath().endsWith("."+tempString.toUpperCase()))
			return true;
		}
		return false;
	}
	
        /**
        *       implement accept from java.io.FilenameFilter
        */
	public boolean accept(File dir, String name)
	{	
		
			return endsWithSuffix(new File(dir, name));
	}
}
