#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>

#include <apr.h>
#include <apr_pools.h>
#include <apr_strings.h>
#include <apr_time.h>
#include <apr_dbd.h>
#include <apr_buckets.h>

#define NARGS     22
#define NBLOBS    2
#define BLOB_SIZE 100000

int main(int argc,char **argv){
  apr_pool_t *pool;
  const char *drivers[][2] = {{"pgsql","dbname=test"},
                              {"mysql","dbname=test,fldsz=8000"},
                              {"sqlite2","./test2.db"},
                              {"sqlite3","./test3.db"},
                              {"oracle","user=bojan pass=bojan dbname=xe server=//shrek.rexursive.com:1521/xe"},
                              {NULL,NULL}};
  size_t i,j,k;
  int nrows, has_prepare;
  const apr_dbd_driver_t *driver;
  apr_dbd_t *sql;
  apr_dbd_prepared_t *stmt;
  apr_dbd_results_t *res;
  apr_dbd_row_t *row;
  apr_status_t rv,rv2[NARGS];
  char d_tiny,d_tiny2;
  unsigned char d_utiny,d_utiny2;
  short d_short,d_short2;
  unsigned short d_ushort,d_ushort2;
  int d_int,d_int2;
  unsigned int d_uint,d_uint2;
  long d_long,d_long2;
  unsigned long d_ulong,d_ulong2;
  apr_int64_t d_longlong,d_longlong2;
  apr_uint64_t d_ulonglong,d_ulonglong2;
  float d_float,d_float2;
  double d_double,d_double2;
  char *d_string,*d_text,*d_time,*d_date,*d_datetime,*d_timestamp,*d_ztimestamp,
       *d_string2,*d_text2,*d_time2,*d_date2,*d_datetime2,*d_timestamp2,
       *d_ztimestamp2,*d_null2,*buf,*query;
  apr_dbd_lob_t *d_blob;
  apr_bucket_alloc_t *balloc;
  apr_bucket_brigade *d_blob2[NBLOBS];
  apr_off_t blen;
  apr_size_t blen2;
  const char *args[NARGS];
  const void *vargs[NARGS];
  char *data;
  int correct;

  apr_initialize();
  apr_pool_create(&pool,NULL);

  apr_dbd_init(pool);

  balloc=apr_bucket_alloc_create(pool);

  for(i=0;drivers[i][0];i++){
    driver=NULL;
    rv=apr_dbd_get_driver(pool,drivers[i][0],&driver);
    if(rv == APR_SUCCESS){
      sql=NULL;
      rv=apr_dbd_open(driver,pool,drivers[i][1],&sql);
      if(rv == APR_SUCCESS){
        stmt=NULL;
        res=NULL;
        row=NULL;

        printf("driver[%u]: name=%s, conn=%s, loaded=%p\n",i,drivers[i][0],
                                                           drivers[i][1],sql);
        rv=apr_dbd_query(driver,sql,&nrows,"delete from test");
        if(rv != APR_SUCCESS)
          continue;

        printf("table cleared, rows affected=%d\n",nrows);

        rv=apr_dbd_prepare(driver,pool,sql,
                           "insert into test values("
                           "%hhd, %hhu, %hd, %hu, %d, %u, %ld, %lu, "
                           "%lld, %llu, %f, %lf, %s, "
                           "%pDt, %pDi, %pDd, %pDa, %pDs, %pDz, "
                           "%pDb, %pDc, %pDn)",
                           "apu_dbd_insert",&stmt);
        switch(rv){
        case APR_ENOTIMPL:
          has_prepare=0;
          break;
        case APR_SUCCESS:
          has_prepare=1;
          break;
        default:
          continue;
        }

        printf("prepared statement=%p\n",stmt);

        d_tiny=-1;
        d_utiny=1;
        d_short=-2;
        d_ushort=2;
        d_int=-3;
        d_uint=3;
        d_long=-4;
        d_ulong=4;
        d_longlong=-5;
        d_ulonglong=5;
        d_float=6;
        d_double=7;
        d_string="string";
        d_text="text";
        d_time="29-AUG-06 11:22";
        if(strcmp(drivers[i][0],"oracle")){
          d_date="2006-08-29";
          d_datetime="2006-08-29 11:22";
          d_timestamp="2006-08-29 11:22";
          d_ztimestamp="2006-08-29 11:22";
        } else{
          d_date="29-AUG-06";
          d_datetime="29-AUG-06 11:22";
          d_timestamp="29-AUG-06 11:22";
          d_ztimestamp="29-AUG-06 11:22:00 AM US/Pacific";
        }
        data=apr_palloc(pool,BLOB_SIZE+1);
        for(j=0;j<BLOB_SIZE;j++)
          *(data+j)='0'+j%10;
        ((char*)(data))[BLOB_SIZE]='\0';
        d_blob=apr_dbd_lob_create(pool,data,BLOB_SIZE,NULL,NULL);

        args[0]=apr_psprintf(pool,"%hd",d_tiny);
        args[1]=apr_psprintf(pool,"%hu",d_utiny);
        args[2]=apr_psprintf(pool,"%hd",d_short);
        args[3]=apr_psprintf(pool,"%hu",d_ushort);
        args[4]=apr_psprintf(pool,"%d",d_int);
        args[5]=apr_psprintf(pool,"%u",d_uint);
        args[6]=apr_psprintf(pool,"%ld",d_long);
        args[7]=apr_psprintf(pool,"%lu",d_ulong);
        args[8]=apr_psprintf(pool,"%" APR_INT64_T_FMT,d_longlong);
        args[9]=apr_psprintf(pool,"%" APR_UINT64_T_FMT,d_ulonglong);
        args[10]=apr_psprintf(pool,"%f",d_float);
        args[11]=apr_psprintf(pool,"%lf",d_double);
        args[12]=d_string;
        args[13]=d_text;
        args[14]=d_time;
        args[15]=d_date;
        args[16]=d_datetime;
        args[17]=d_timestamp;
        args[18]=d_ztimestamp;
        args[19]=apr_psprintf(pool,"%" APR_SIZE_T_FMT ":::%s",
                              apr_dbd_lob_size_get(d_blob),
                              apr_dbd_lob_data_get(d_blob));
        args[20]=apr_psprintf(pool,"%" APR_SIZE_T_FMT ":::%s",
                              apr_dbd_lob_size_get(d_blob),
                              apr_dbd_lob_data_get(d_blob));
        args[21]=NULL;

        for(j=0;j<NARGS;j++)
          printf("args[%u]=%.60s\n",j,args[j]);

        if(has_prepare){
          rv=apr_dbd_pquery(driver,pool,sql,&nrows,stmt,NARGS,args);
          if(rv != APR_SUCCESS)
            continue;
        } else{
          query="";
          query=apr_pstrcat(pool,"insert into test values('",
                            args[0],"','",
                            args[1],"','",
                            args[2],"','",
                            args[3],"','",
                            args[4],"','",
                            args[5],"','",
                            args[6],"','",
                            args[7],"','",
                            args[8],"','",
                            args[9],"','",
                            args[10],"','",
                            args[11],"','",
                            args[12],"','",
                            args[13],"','",
                            args[14],"','",
                            args[15],"','",
                            args[16],"','",
                            args[17],"','",
                            args[18],"','",
                            apr_dbd_lob_data_get(d_blob),"','",
                            apr_dbd_lob_data_get(d_blob),"',",
                            "NULL)",
                            NULL);
          rv=apr_dbd_query(driver,sql,&nrows,query);
          if(rv != APR_SUCCESS)
            continue;
        }

        printf("query status=%d\n",rv);

        vargs[0]=&d_tiny;
        vargs[1]=&d_utiny;
        vargs[2]=&d_short;
        vargs[3]=&d_ushort;
        vargs[4]=&d_int;
        vargs[5]=&d_uint;
        vargs[6]=&d_long;
        vargs[7]=&d_ulong;
        vargs[8]=&d_longlong;
        vargs[9]=&d_ulonglong;
        vargs[10]=&d_float;
        vargs[11]=&d_double;
        vargs[12]=d_string;
        vargs[13]=d_text;
        vargs[14]=d_time;
        vargs[15]=d_date;
        vargs[16]=d_datetime;
        vargs[17]=d_timestamp;
        vargs[18]=d_ztimestamp;
        vargs[19]=d_blob;
        vargs[20]=d_blob;
        vargs[21]=NULL;

        if(has_prepare){
          rv=apr_dbd_pbquery(driver,pool,sql,&nrows,stmt,NARGS,vargs);
          if(rv != APR_SUCCESS)
            continue;
        } else{
          rv=apr_dbd_query(driver,sql,&nrows,query);
          if(rv != APR_SUCCESS)
            continue;
        }

        printf("query status=%d\n",rv);

        if(has_prepare){
          rv=apr_dbd_prepare(driver,pool,sql,"select * from test",
                             "apu_dbd_select",&stmt);
          if(rv != APR_SUCCESS)
            continue;

          printf("prepared statement=%p\n",stmt);

          res=NULL;
          rv = apr_dbd_pbselect(driver,pool,sql,&res,stmt,0,0,NULL);
          if(rv != APR_SUCCESS)
            continue;
        } else{
          rv=apr_dbd_select(driver,pool,sql,&res,"select * from test",0);
          if(rv != APR_SUCCESS)
            continue;
        }

        printf("result=%p\n",res);

        while(!apr_dbd_get_row(driver,pool,res,&row,-1)){
          for(k=0;k<NBLOBS;k++)
            d_blob2[k]=apr_brigade_create(pool,balloc);

          rv2[0]=apr_dbd_datum_get(driver,row,0,APR_DBD_TYPE_TINY,&d_tiny2); 
          rv2[1]=apr_dbd_datum_get(driver,row,1,APR_DBD_TYPE_UTINY,&d_utiny2); 
          rv2[2]=apr_dbd_datum_get(driver,row,2,APR_DBD_TYPE_SHORT,&d_short2); 
          rv2[3]=apr_dbd_datum_get(driver,row,3,APR_DBD_TYPE_USHORT,&d_ushort2); 
          rv2[4]=apr_dbd_datum_get(driver,row,4,APR_DBD_TYPE_INT,&d_int2); 
          rv2[5]=apr_dbd_datum_get(driver,row,5,APR_DBD_TYPE_UINT,&d_uint2); 
          rv2[6]=apr_dbd_datum_get(driver,row,6,APR_DBD_TYPE_LONG,&d_long2); 
          rv2[7]=apr_dbd_datum_get(driver,row,7,APR_DBD_TYPE_ULONG,&d_ulong2); 
          rv2[8]=apr_dbd_datum_get(driver,row,8,APR_DBD_TYPE_LONGLONG,&d_longlong2); 
          rv2[9]=apr_dbd_datum_get(driver,row,9,APR_DBD_TYPE_ULONGLONG,&d_ulonglong2); 
          rv2[10]=apr_dbd_datum_get(driver,row,10,APR_DBD_TYPE_FLOAT,&d_float2); 
          rv2[11]=apr_dbd_datum_get(driver,row,11,APR_DBD_TYPE_DOUBLE,&d_double2); 
          rv2[12]=apr_dbd_datum_get(driver,row,12,APR_DBD_TYPE_STRING,&d_string2); 
          rv2[13]=apr_dbd_datum_get(driver,row,13,APR_DBD_TYPE_TEXT,&d_text2); 
          rv2[14]=apr_dbd_datum_get(driver,row,14,APR_DBD_TYPE_TIME,&d_time2); 
          rv2[15]=apr_dbd_datum_get(driver,row,15,APR_DBD_TYPE_DATE,&d_date2); 
          rv2[16]=apr_dbd_datum_get(driver,row,16,APR_DBD_TYPE_DATETIME,&d_datetime2); 
          rv2[17]=apr_dbd_datum_get(driver,row,17,APR_DBD_TYPE_TIMESTAMP,&d_timestamp2); 
          rv2[18]=apr_dbd_datum_get(driver,row,18,APR_DBD_TYPE_ZTIMESTAMP,&d_ztimestamp2); 
          rv2[19]=apr_dbd_datum_get(driver,row,19,APR_DBD_TYPE_BLOB,d_blob2[0]); 
          rv2[20]=apr_dbd_datum_get(driver,row,20,APR_DBD_TYPE_CLOB,d_blob2[1]); 
          rv2[21]=apr_dbd_datum_get(driver,row,21,APR_DBD_TYPE_NULL,&d_null2); 

          for(j=0;j<NARGS;j++){
            switch(rv2[j]){
            case APR_ENOENT:
              printf("value[%d] is NULL\n",j);
              break;
            case APR_EGENERAL:
              printf("error fetching value[%d]\n",j);
              break;
            }
          }

          printf("%hhd %hhu %hd %hu %d %u %ld %lu "
                 "%" APR_INT64_T_FMT " %" APR_UINT64_T_FMT " %f %lf "
                 "%s %s %s %s %s %s %s %p %p %p\n",
                 d_tiny2,d_utiny2,d_short2,d_ushort2,d_int2,d_uint2,
                 d_long2,d_ulong2,d_longlong2,d_ulonglong2,d_float2,d_double2,
                 d_string2,d_text2,d_time2,d_date2,d_datetime2,d_timestamp2,
                 d_ztimestamp2,d_blob2[0],d_blob2[1],d_null2);

          for(k=0;k<NBLOBS;k++){
            apr_brigade_length(d_blob2[k],1,&blen);
            blen2=blen;
            buf=NULL;
            apr_brigade_pflatten(d_blob2[k],&buf,&blen2,pool);

            correct=1;
            for(j=0;j<blen;j++)
              if(buf[j]!='0'+j%10){
                correct=0;
                break;
              }

            printf("blob=%.*s, length=%"
                   APR_OFF_T_FMT ", correct=%d\n",40,buf,blen,correct);

            apr_brigade_destroy(d_blob2[k]);
          }
        }
      }
      if(sql)
        apr_dbd_close(driver,sql);
    }
  }

  apr_terminate();
  return 0;
}
