package main

import (
	"flag"
	"fmt"

	"aurora/client2"
)

var auroraUrl = flag.String("url", "", "Url to aurora_master/apibeta")

func RunBench() {
	roleSummaryResult, err := client2.GetRoleSummary(*auroraUrl)
	if err != nil {
		panic(err)
	}
	fmt.Println("Got role summary result")
	for ii, _ := range roleSummaryResult.Summaries {
		jobSummaryRequest := client2.JobSummaryRequest{Role: roleSummaryResult.Summaries[ii].Role}
		jobSummaryResult, err := client2.GetJobSummary(*auroraUrl, &jobSummaryRequest)
		if err != nil {
			panic(err)
		}
		fmt.Println("Got job summary result")
		for jj, _ := range jobSummaryResult.Summaries {
			jobSummary := &jobSummaryResult.Summaries[jj]
			taskStatusRequest := client2.TaskStatusRequest{
				Query: client2.TaskStatusQuery{
					Role:        jobSummary.Job.Key.Role,
					Environment: client2.EnvProduction,
					JobName:     jobSummary.Job.Key.Name,
				},
			}
			_, err := client2.GetTaskStatus(*auroraUrl, &taskStatusRequest)
			if err != nil {
				panic(err)
			}
			fmt.Println("Got task status result")
		}
	}
}

func main() {
	flag.Parse()
	RunBench()
}
