// Client API to aurora scheduler.

package client2

// Response codes.

// ResponseInvalidRequest
const ResponseInvalidRequest = "INVALID_REQUEST"
const ResponseOK = "OK"
const ResponseError = "ERROR"
const ResponseWarning = "WARNING"
const ResponseAuthFailed = "AUTH_FAILED"
const ResponseLockError = "LOCK_ERROR"
const ResponseTransientError = "ERROR_TRANSIENT"

// Cron collision policies.
const CronKillExisting = "KILL_EXISTING"
const CronCancelNew = "CANCEL_NEW"

// Schedule Status codes.
const StatusInit = "INIT"
const StatusThrottled = "THROTTLED"
const StatusPending = "PENDING"
const StatusAssigned = "ASSIGNED"
const StatusStarting = "STARTING"
const StatusRunning = "RUNNING"
const StatusFinished = "FINISHED"
const StatusPreempting = "PREEMPTING"
const StatusRestarting = "RESTARTING"
const StatusDraining = "DRAINING"
const StatusFailed = "FAILED"
const StatusKilled = "KILLED"
const StatusKilling = "KILLING"
const StatusLost = "LOST"
const StatusSandboxDeleted = "SANDBOX_DELETED"

// Environment definitions.
const EnvDevelopment = "devel"
const EnvProduction = "prod"

// Top-level response metadata.

type Response struct {
	ResponseCode string
	ServerInfo   ServerInfo
	Result       Result
	Details      []ResponseDetail
}

type ServerInfo struct {
	ClusterName      string
	ThriftAPIVersion int
	StatusUrlPrefix  string
}

type ResponseDetail struct {
	Message string
}

type Result struct {
	PopulateJobResult           PopulateJobResult
	ScheduleStatusResult        TaskStatusResult
	GetJobsResult               GetJobsResult
	GetQuotaResult              GetQuotaResult
	ListBackupsResult           ListBackupsResult
	StartMaintenanceResult      StartMaintenanceResult
	DrainHostsResult            DrainHostsResult
	QueryRecoveryResult         QueryRecoveryResult
	MaintenanceStatusResult     MaintenanceStatusResult
	EndMaintenanceResult        EndMaintenanceResult
	APIVersion                  GetVersionResult
	AcquireLockResult           AcquireLockResult
	RoleSummaryResult           RoleSummaryResult
	JobSummaryResult            JobSummaryResult
	GetLocksResult              GetLocksResult
	ConfigSummaryResult         ConfigSummaryResult
	GetPendingReasonResult      GetPendingReasonResult
	StartJobUpdateResult        StartJobUpdateResult
	GetJobUpdateSummariesResult GetJobUpdateSummariesResult
	GetJobUpdateDetailsResult   GetJobUpdateDetailsResult
	PulseJobUpdateResult        PulseJobUpdateResult
}

// Method request/response payloads.

type PopulateJobResult struct {
}

type TaskStatusRequest struct {
	Query TaskStatusQuery `json:"query"`
}

type TaskStatusQuery struct {
	Owner       Identity `json:"owner,omitempty"`
	Role        string   `json:"role,omitempty"`
	Environment string   `json:"environment,omitempty"`
	JobName     string   `json:"jobName,omitempty"`
	TaskIds     []string `json:"taskIds,omitempty"`
	Statuses    []string `json:"statuses,omitempty"`
	InstanceIds []string `json:"instanceIds,omitempty"`
	SlaveHosts  []string `json:"slaveHosts,omitempty"`
	JobKeys     []JobKey `json:"jobKeys,omitempty"`
	Offset      int      `json:"offset,omitempty"`
	Limit       int      `json:"limit,omitempty"`
}

type TaskStatusResult struct {
	Tasks []ScheduledTask
}

type GetJobsResult struct {
}

type GetQuotaResult struct {
}

type ListBackupsResult struct {
}

type StartMaintenanceResult struct {
}

type DrainHostsResult struct {
}

type QueryRecoveryResult struct {
}

type MaintenanceStatusResult struct {
}

type EndMaintenanceResult struct {
}

type GetVersionResult struct {
}

type AcquireLockResult struct {
}

type RoleSummaryResult struct {
	Summaries []RoleSummary
}

type JobSummaryRequest struct {
	Role string
}

type JobSummaryResult struct {
	Summaries []JobSummary
}

type GetLocksResult struct {
}

type ConfigSummaryResult struct {
}

type GetPendingReasonResult struct {
}

type StartJobUpdateResult struct {
}

type GetJobUpdateSummariesResult struct {
}

type GetJobUpdateDetailsResult struct {
}

type PulseJobUpdateResult struct {
}

// Supporting data structures.

type AssignedTask struct {
	TaskId        string
	SlaveId       string
	SlaveHost     string
	Task          TaskConfig
	AssignedPorts map[string]int
	InstanceId    int
}

type Constraint struct {
	Name       string
	Constraint TaskConstraint
}

type ExecutorConfig struct {
	Name string
	Data string
}

type Identity struct {
	Role string `json:"role,omitempty"`
	User string `json:"user,omitempty"`
}

type JobConfiguration struct {
	Key                 JobKey
	Owner               Identity
	CronSchedule        string
	CronCollisionPolicy string
	TaskConfig          TaskConfig
	InstanceCount       int
}

type JobKey struct {
	Role        string `json:"role,omitempty"`
	Environment string `json:"environment,omitempty"`
	Name        string `json:"name,omitempty"`
}

type JobStats struct {
	ActiveTaskCount   int
	FinishedTaskCount int
	FailedTaskCount   int
	PendingTaskCount  int
}

type JobSummary struct {
	Job           JobConfiguration
	Stats         JobStats
	NextCronRunMs int64
}

type LimitConstraint struct {
	Limit int
}

type Metadata struct {
	Key   string
	Value string
}

type RoleSummary struct {
	Role         string
	JobCount     int
	CronJobCount int
}

type ScheduledTask struct {
	AssignedTask AssignedTask
	Status       string
	FailureCount int
	TaskEvents   []TaskEvent
	AncestorId   string
}

type TaskConfig struct {
	Job             JobKey
	Owner           Identity
	Environment     string
	JobName         string
	IsService       bool
	NumCpus         float64
	RamMb           int64
	DiskMb          int64
	Priority        int
	MaxTaskFailures int
	Production      bool
	Constraints     []Constraint
	RequestedPorts  []string
	TaskLinks       map[string]string
	ContactEmail    string
	ExecutorConfig  ExecutorConfig
	Metadata        []Metadata
}

type TaskConstraint struct {
	Value ValueConstraint
	Limit LimitConstraint
}

type TaskEvent struct {
	Timestamp int64
	Status    string
	Message   string
	Scheduler string
}

type ValueConstraint struct {
	Negated bool
	Values  []string
}
