import gdb.printing
import gdb.types
import pthread_printers

class bundle_printer:
    def __init__(self, val):
        self.val = val

    def to_string(self):
        return "bundle";

    def children(self):
        out_list = []
        out_list.append(("context"  , str(self.val["context"])))
        out_list.append(("activator", str(self.val["activator"])))
        out_list.append(("state"    , str(self.val["state"])))
        out_list.append(("handle"   , str(self.val["handle"])))
        out_list.append(("archive"  , "<" + bundle_archive_printer(self.val["archive"]).to_short_string() + ">"))

        try:
            modules_arrayList = self.val["modules"].dereference()
            modules_array = modules_arrayList["elementData"]

            sub_str = "count = " + str(modules_arrayList["size"]) + ", "
            for idx in xrange(modules_arrayList["size"]):
                try:
                    p_module    = modules_array[idx].cast(gdb.lookup_type("module_pt"))
                    module      = p_module.dereference()
                    sub_str     += "<" + module_printer(module).to_short_string() + ">"
                except gdb.MemoryError:
                    sub_str += "<(invalid pointer)" + str(modules_array[idx]) + ">"
        except gdb.MemoryError:
            out_list.append(("modules", "(invalid pointer)" + str(self.val["modules"])))
        else:
            out_list.append(("modules", "<" + sub_str + ">"))


        lock_union = self.val["lock"]
        out_list.append(("lock", "<" + pthread_printers.mutex_printer(lock_union["__data"]).to_short_string() + ">"))

        return out_list

class bundle_archive_printer:
    def __init__(self, val):
        self.val = val

    def to_string(self):
        return "bundle_archive"

    def to_short_string(self):
        try:
            sub_str = ("location = <" + str(self.val["location"]) 
                + ">, id = " + str(self.val["id"]))
        except gdb.MemoryError:
            sub_str = "(invalid pointer)" + str(self.val)

        return sub_str

    def children(self):
        out_list = []
        out_list.append(("id"           , str(self.val["id"])))
        out_list.append(("location"     , str(self.val["location"])))
        out_list.append(("archiveRootDir",str(self.val["archiveRootDir"])))
        out_list.append(("archiveRoot"  , str(self.val["archiveRoot"])))

        try:
            revisions_linkedList = self.val["revisions"].dereference()
            revisions_list_header = revisions_linkedList["header"]
            revision_node = revisions_list_header["next"]

            sub_str = "count = " + str(revisions_linkedList["size"]) + ", "
            for idx in xrange(revisions_linkedList["size"]):
                try:
                    revision_pt = revision_node["element"].cast(gdb.lookup_type("bundle_revision_pt"))
                    revision = revision_pt.dereference()
                    sub_str     += "<" + str(revision_pt) + "<" + "revisionNr" + str(revision["revisionNr"]) +  ">>"
                    revision_node = revisions_list_header["next"]

                except gdb.MemoryError:
                    sub_str += "<(invalid pointer)" + str(revision_pt) + ">"
        except gdb.MemoryError:
            out_list.append(("modules", "(invalid pointer)" + str(self.val["revisions"])))
        else:
            out_list.append(("revisions", "<" + sub_str + ">"))

        out_list.append(("refreshCount"     , str(self.val["refreshCount"])))
        out_list.append(("lastModified"     , str(self.val["lastModified"])))
        out_list.append(("persistentState"  , str(self.val["persistentState"])))

        return out_list

class module_printer:
    def __init__(self, val):
        self.val = val

    def to_string(self):
        return "module"

    def to_short_string(self):
        try:
            sub_str = ("symbolicName=<" + str(self.val["symbolicName"]) 
                + ">, id=<" + str(self.val["id"]) + ">")
        except gdb.MemoryError:
            sub_str = "(invalid pointer)" + str(self.val)
            
        return sub_str

    def children(self):
        out_list = []
        out_list.append("not implemented")
        return out_list
        #See bundleArchive printer for example printing lists

        #linked_list_pt capabilities;
        #linked_list_pt requirements;
        #linked_list_pt wires;
        #array_list_pt dependentImporters;
        #version_pt version;
        #char *symbolicName;
        #_Bool resolved;
        #manifest_pt headerMap;
        #char *id;
        #struct bundle *bundle;


def add_celix_printers():
    celix_pp = gdb.printing.RegexpCollectionPrettyPrinter("celix_printers_library")
    celix_pp.add_printer('bundle', '^bundle$', bundle_printer)
    celix_pp.add_printer('bundleArchive', '^bundleArchive$', bundle_archive_printer)
#    celix_pp.add_printer('module', '^module$', module_printer)
    return celix_pp
